package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetShardRoleInputBuilder} instances.
 *
 * @see GetShardRoleInputBuilder
 *
 */
public class GetShardRoleInputBuilder implements Builder<GetShardRoleInput> {

    private DataStoreType _dataStoreType;
    private String _shardName;


    Map<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>> augmentation = Collections.emptyMap();

    public GetShardRoleInputBuilder() {
    }

    public GetShardRoleInputBuilder(GetShardRoleInput base) {
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
        if (base instanceof GetShardRoleInputImpl) {
            GetShardRoleInputImpl impl = (GetShardRoleInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>> aug =((AugmentationHolder<GetShardRoleInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public String getShardName() {
        return _shardName;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetShardRoleInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public GetShardRoleInputBuilder setShardName(final String value) {
        this._shardName = value;
        return this;
    }
    
    public GetShardRoleInputBuilder addAugmentation(Class<? extends Augmentation<GetShardRoleInput>> augmentationType, Augmentation<GetShardRoleInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetShardRoleInputBuilder removeAugmentation(Class<? extends Augmentation<GetShardRoleInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetShardRoleInput build() {
        return new GetShardRoleInputImpl(this);
    }

    private static final class GetShardRoleInputImpl implements GetShardRoleInput {
    
        private final DataStoreType _dataStoreType;
        private final String _shardName;
    
        private Map<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>> augmentation = Collections.emptyMap();
    
        GetShardRoleInputImpl(GetShardRoleInputBuilder base) {
            this._dataStoreType = base.getDataStoreType();
            this._shardName = base.getShardName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<GetShardRoleInput> getImplementedInterface() {
            return GetShardRoleInput.class;
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public String getShardName() {
            return _shardName;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<GetShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_shardName);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetShardRoleInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetShardRoleInput other = (GetShardRoleInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_shardName, other.getShardName())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetShardRoleInputImpl otherImpl = (GetShardRoleInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetShardRoleInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_shardName", _shardName);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
