package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.String;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * output {
 *   leaf role {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/get-shard-role/output</i>
 *
 * <p>To create instances of this class use {@link GetShardRoleOutputBuilder}.
 * @see GetShardRoleOutputBuilder
 *
 */
public interface GetShardRoleOutput
    extends
    RpcOutput,
    Augmentable<GetShardRoleOutput>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    /**
     * Current role for the given shard, if not present the shard currently doesn't 
     * have a role
     *
     *
     *
     * @return <code>java.lang.String</code> <code>role</code>, or <code>null</code> if not present
     */
    @Nullable String getRole();

}

