package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetShardRoleOutputBuilder} instances.
 *
 * @see GetShardRoleOutputBuilder
 *
 */
public class GetShardRoleOutputBuilder implements Builder<GetShardRoleOutput> {

    private String _role;


    Map<Class<? extends Augmentation<GetShardRoleOutput>>, Augmentation<GetShardRoleOutput>> augmentation = Collections.emptyMap();

    public GetShardRoleOutputBuilder() {
    }

    public GetShardRoleOutputBuilder(GetShardRoleOutput base) {
        this._role = base.getRole();
        if (base instanceof GetShardRoleOutputImpl) {
            GetShardRoleOutputImpl impl = (GetShardRoleOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetShardRoleOutput>>, Augmentation<GetShardRoleOutput>> aug =((AugmentationHolder<GetShardRoleOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getRole() {
        return _role;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetShardRoleOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetShardRoleOutputBuilder setRole(final String value) {
        this._role = value;
        return this;
    }
    
    public GetShardRoleOutputBuilder addAugmentation(Class<? extends Augmentation<GetShardRoleOutput>> augmentationType, Augmentation<GetShardRoleOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetShardRoleOutputBuilder removeAugmentation(Class<? extends Augmentation<GetShardRoleOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetShardRoleOutput build() {
        return new GetShardRoleOutputImpl(this);
    }

    private static final class GetShardRoleOutputImpl implements GetShardRoleOutput {
    
        private final String _role;
    
        private Map<Class<? extends Augmentation<GetShardRoleOutput>>, Augmentation<GetShardRoleOutput>> augmentation = Collections.emptyMap();
    
        GetShardRoleOutputImpl(GetShardRoleOutputBuilder base) {
            this._role = base.getRole();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<GetShardRoleOutput> getImplementedInterface() {
            return GetShardRoleOutput.class;
        }
    
        @Override
        public String getRole() {
            return _role;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<GetShardRoleOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_role);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetShardRoleOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetShardRoleOutput other = (GetShardRoleOutput)obj;
            if (!Objects.equals(_role, other.getRole())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetShardRoleOutputImpl otherImpl = (GetShardRoleOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetShardRoleOutput>>, Augmentation<GetShardRoleOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetShardRoleOutput");
            CodeHelpers.appendValue(helper, "_role", _role);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
