package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * grouping member-voting-states-input {
 *   list member-voting-state {
 *     leaf member-name {
 *       type string;
 *     }
 *     leaf voting {
 *       type boolean;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/member-voting-states-input</i>
 *
 */
public interface MemberVotingStatesInput
    extends
    DataObject
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("member-voting-states-input");

    /**
     * The list of member voting states
     *
     *
     *
     * @return <code>java.util.List</code> <code>memberVotingState</code>, or <code>null</code> if not present
     */
    @Nullable List<MemberVotingState> getMemberVotingState();
    
    /**
     * @return <code>java.util.List</code> <code>memberVotingState</code>, or an empty list if it is not present
     */
    default @NonNull List<MemberVotingState> nonnullMemberVotingState() {
        return CodeHelpers.nonnull(getMemberVotingState());
    }

}

