package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.String;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input {
 *   leaf member-name {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/remove-all-shard-replicas/input</i>
 *
 * <p>To create instances of this class use {@link RemoveAllShardReplicasInputBuilder}.
 * @see RemoveAllShardReplicasInputBuilder
 *
 */
public interface RemoveAllShardReplicasInput
    extends
    RpcInput,
    Augmentable<RemoveAllShardReplicasInput>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    /**
     * The cluster member from which the shard replicas should be removed
     *
     *
     *
     * @return <code>java.lang.String</code> <code>memberName</code>, or <code>null</code> if not present
     */
    @Nullable String getMemberName();

}

