package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RemoveAllShardReplicasInputBuilder} instances.
 *
 * @see RemoveAllShardReplicasInputBuilder
 *
 */
public class RemoveAllShardReplicasInputBuilder implements Builder<RemoveAllShardReplicasInput> {

    private String _memberName;


    Map<Class<? extends Augmentation<RemoveAllShardReplicasInput>>, Augmentation<RemoveAllShardReplicasInput>> augmentation = Collections.emptyMap();

    public RemoveAllShardReplicasInputBuilder() {
    }

    public RemoveAllShardReplicasInputBuilder(RemoveAllShardReplicasInput base) {
        this._memberName = base.getMemberName();
        if (base instanceof RemoveAllShardReplicasInputImpl) {
            RemoveAllShardReplicasInputImpl impl = (RemoveAllShardReplicasInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RemoveAllShardReplicasInput>>, Augmentation<RemoveAllShardReplicasInput>> aug =((AugmentationHolder<RemoveAllShardReplicasInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getMemberName() {
        return _memberName;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemoveAllShardReplicasInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RemoveAllShardReplicasInputBuilder setMemberName(final String value) {
        this._memberName = value;
        return this;
    }
    
    public RemoveAllShardReplicasInputBuilder addAugmentation(Class<? extends Augmentation<RemoveAllShardReplicasInput>> augmentationType, Augmentation<RemoveAllShardReplicasInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RemoveAllShardReplicasInputBuilder removeAugmentation(Class<? extends Augmentation<RemoveAllShardReplicasInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RemoveAllShardReplicasInput build() {
        return new RemoveAllShardReplicasInputImpl(this);
    }

    private static final class RemoveAllShardReplicasInputImpl implements RemoveAllShardReplicasInput {
    
        private final String _memberName;
    
        private Map<Class<? extends Augmentation<RemoveAllShardReplicasInput>>, Augmentation<RemoveAllShardReplicasInput>> augmentation = Collections.emptyMap();
    
        RemoveAllShardReplicasInputImpl(RemoveAllShardReplicasInputBuilder base) {
            this._memberName = base.getMemberName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<RemoveAllShardReplicasInput> getImplementedInterface() {
            return RemoveAllShardReplicasInput.class;
        }
    
        @Override
        public String getMemberName() {
            return _memberName;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<RemoveAllShardReplicasInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_memberName);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveAllShardReplicasInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RemoveAllShardReplicasInput other = (RemoveAllShardReplicasInput)obj;
            if (!Objects.equals(_memberName, other.getMemberName())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RemoveAllShardReplicasInputImpl otherImpl = (RemoveAllShardReplicasInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RemoveAllShardReplicasInput>>, Augmentation<RemoveAllShardReplicasInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemoveAllShardReplicasInput");
            CodeHelpers.appendValue(helper, "_memberName", _memberName);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
