package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link RemovePrefixShardReplicaInputBuilder} instances.
 *
 * @see RemovePrefixShardReplicaInputBuilder
 *
 */
public class RemovePrefixShardReplicaInputBuilder implements Builder<RemovePrefixShardReplicaInput> {

    private DataStoreType _dataStoreType;
    private String _memberName;
    private InstanceIdentifier<?> _shardPrefix;


    Map<Class<? extends Augmentation<RemovePrefixShardReplicaInput>>, Augmentation<RemovePrefixShardReplicaInput>> augmentation = Collections.emptyMap();

    public RemovePrefixShardReplicaInputBuilder() {
    }

    public RemovePrefixShardReplicaInputBuilder(RemovePrefixShardReplicaInput base) {
        this._dataStoreType = base.getDataStoreType();
        this._memberName = base.getMemberName();
        this._shardPrefix = base.getShardPrefix();
        if (base instanceof RemovePrefixShardReplicaInputImpl) {
            RemovePrefixShardReplicaInputImpl impl = (RemovePrefixShardReplicaInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RemovePrefixShardReplicaInput>>, Augmentation<RemovePrefixShardReplicaInput>> aug =((AugmentationHolder<RemovePrefixShardReplicaInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public String getMemberName() {
        return _memberName;
    }
    
    public InstanceIdentifier<?> getShardPrefix() {
        return _shardPrefix;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemovePrefixShardReplicaInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RemovePrefixShardReplicaInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public RemovePrefixShardReplicaInputBuilder setMemberName(final String value) {
        this._memberName = value;
        return this;
    }
    
    public RemovePrefixShardReplicaInputBuilder setShardPrefix(final InstanceIdentifier<?> value) {
        this._shardPrefix = value;
        return this;
    }
    
    public RemovePrefixShardReplicaInputBuilder addAugmentation(Class<? extends Augmentation<RemovePrefixShardReplicaInput>> augmentationType, Augmentation<RemovePrefixShardReplicaInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RemovePrefixShardReplicaInputBuilder removeAugmentation(Class<? extends Augmentation<RemovePrefixShardReplicaInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RemovePrefixShardReplicaInput build() {
        return new RemovePrefixShardReplicaInputImpl(this);
    }

    private static final class RemovePrefixShardReplicaInputImpl implements RemovePrefixShardReplicaInput {
    
        private final DataStoreType _dataStoreType;
        private final String _memberName;
        private final InstanceIdentifier<?> _shardPrefix;
    
        private Map<Class<? extends Augmentation<RemovePrefixShardReplicaInput>>, Augmentation<RemovePrefixShardReplicaInput>> augmentation = Collections.emptyMap();
    
        RemovePrefixShardReplicaInputImpl(RemovePrefixShardReplicaInputBuilder base) {
            this._dataStoreType = base.getDataStoreType();
            this._memberName = base.getMemberName();
            this._shardPrefix = base.getShardPrefix();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<RemovePrefixShardReplicaInput> getImplementedInterface() {
            return RemovePrefixShardReplicaInput.class;
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public String getMemberName() {
            return _memberName;
        }
        
        @Override
        public InstanceIdentifier<?> getShardPrefix() {
            return _shardPrefix;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<RemovePrefixShardReplicaInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_memberName);
            result = prime * result + Objects.hashCode(_shardPrefix);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemovePrefixShardReplicaInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RemovePrefixShardReplicaInput other = (RemovePrefixShardReplicaInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_memberName, other.getMemberName())) {
                return false;
            }
            if (!Objects.equals(_shardPrefix, other.getShardPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RemovePrefixShardReplicaInputImpl otherImpl = (RemovePrefixShardReplicaInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RemovePrefixShardReplicaInput>>, Augmentation<RemovePrefixShardReplicaInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemovePrefixShardReplicaInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_memberName", _memberName);
            CodeHelpers.appendValue(helper, "_shardPrefix", _shardPrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
