package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Boolean;
import java.lang.String;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * grouping shard-operation-result {
 *   leaf shard-name {
 *     type string;
 *   }
 *   leaf data-store-type {
 *     type data-store-type;
 *   }
 *   leaf succeeded {
 *     type boolean;
 *   }
 *   leaf error-message {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/shard-operation-result</i>
 *
 */
public interface ShardOperationResult
    extends
    DataObject
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("shard-operation-result");

    /**
     * @return <code>java.lang.String</code> <code>shardName</code>, or <code>null</code> if not present
     */
    @Nullable String getShardName();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType</code> <code>dataStoreType</code>, or <code>null</code> if not present
     */
    @Nullable DataStoreType getDataStoreType();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>succeeded</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isSucceeded();
    
    /**
     * @return <code>java.lang.String</code> <code>errorMessage</code>, or <code>null</code> if not present
     */
    @Nullable String getErrorMessage();

}

