package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MemberVotingStateBuilder} instances.
 *
 * @see MemberVotingStateBuilder
 *
 */
public class MemberVotingStateBuilder implements Builder<MemberVotingState> {

    private String _memberName;
    private Boolean _voting;


    Map<Class<? extends Augmentation<MemberVotingState>>, Augmentation<MemberVotingState>> augmentation = Collections.emptyMap();

    public MemberVotingStateBuilder() {
    }

    public MemberVotingStateBuilder(MemberVotingState base) {
        this._memberName = base.getMemberName();
        this._voting = base.isVoting();
        if (base instanceof MemberVotingStateImpl) {
            MemberVotingStateImpl impl = (MemberVotingStateImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<MemberVotingState>>, Augmentation<MemberVotingState>> aug =((AugmentationHolder<MemberVotingState>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getMemberName() {
        return _memberName;
    }
    
    public Boolean isVoting() {
        return _voting;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MemberVotingState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public MemberVotingStateBuilder setMemberName(final String value) {
        this._memberName = value;
        return this;
    }
    
    public MemberVotingStateBuilder setVoting(final Boolean value) {
        this._voting = value;
        return this;
    }
    
    public MemberVotingStateBuilder addAugmentation(Class<? extends Augmentation<MemberVotingState>> augmentationType, Augmentation<MemberVotingState> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MemberVotingStateBuilder removeAugmentation(Class<? extends Augmentation<MemberVotingState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MemberVotingState build() {
        return new MemberVotingStateImpl(this);
    }

    private static final class MemberVotingStateImpl implements MemberVotingState {
    
        private final String _memberName;
        private final Boolean _voting;
    
        private Map<Class<? extends Augmentation<MemberVotingState>>, Augmentation<MemberVotingState>> augmentation = Collections.emptyMap();
    
        MemberVotingStateImpl(MemberVotingStateBuilder base) {
            this._memberName = base.getMemberName();
            this._voting = base.isVoting();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<MemberVotingState> getImplementedInterface() {
            return MemberVotingState.class;
        }
    
        @Override
        public String getMemberName() {
            return _memberName;
        }
        
        @Override
        public Boolean isVoting() {
            return _voting;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<MemberVotingState>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_memberName);
            result = prime * result + Objects.hashCode(_voting);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MemberVotingState.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MemberVotingState other = (MemberVotingState)obj;
            if (!Objects.equals(_memberName, other.getMemberName())) {
                return false;
            }
            if (!Objects.equals(_voting, other.isVoting())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MemberVotingStateImpl otherImpl = (MemberVotingStateImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<MemberVotingState>>, Augmentation<MemberVotingState>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MemberVotingState");
            CodeHelpers.appendValue(helper, "_memberName", _memberName);
            CodeHelpers.appendValue(helper, "_voting", _voting);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
