/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MakeLeaderLocalInputBuilder
implements Builder<MakeLeaderLocalInput> {
    private DataStoreType _dataStoreType;
    private String _shardName;
    Map<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>> augmentation = Collections.emptyMap();

    public MakeLeaderLocalInputBuilder() {
    }

    public MakeLeaderLocalInputBuilder(DatastoreShardId arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public MakeLeaderLocalInputBuilder(MakeLeaderLocalInput base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>>(aug);
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DatastoreShardId) {
            this._shardName = ((DatastoreShardId)arg).getShardName();
            this._dataStoreType = ((DatastoreShardId)arg).getDataStoreType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId]");
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getShardName() {
        return this._shardName;
    }

    public <E$$ extends Augmentation<MakeLeaderLocalInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MakeLeaderLocalInputBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    private static void check_shardNameLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public MakeLeaderLocalInputBuilder setShardName(String value) {
        if (value != null) {
            MakeLeaderLocalInputBuilder.check_shardNameLength(value);
        }
        this._shardName = value;
        return this;
    }

    public MakeLeaderLocalInputBuilder addAugmentation(Augmentation<MakeLeaderLocalInput> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public MakeLeaderLocalInputBuilder addAugmentation(Class<? extends Augmentation<MakeLeaderLocalInput>> augmentationType, Augmentation<MakeLeaderLocalInput> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public MakeLeaderLocalInputBuilder removeAugmentation(Class<? extends Augmentation<MakeLeaderLocalInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private MakeLeaderLocalInputBuilder doAddAugmentation(Class<? extends Augmentation<MakeLeaderLocalInput>> augmentationType, Augmentation<MakeLeaderLocalInput> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MakeLeaderLocalInput build() {
        return new MakeLeaderLocalInputImpl(this);
    }

    private static final class MakeLeaderLocalInputImpl
    extends AbstractAugmentable<MakeLeaderLocalInput>
    implements MakeLeaderLocalInput {
        private final DataStoreType _dataStoreType;
        private final String _shardName;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MakeLeaderLocalInputImpl(MakeLeaderLocalInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardName = base.getShardName();
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._dataStoreType);
            result = 31 * result + Objects.hashCode(this._shardName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MakeLeaderLocalInput.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MakeLeaderLocalInput other = (MakeLeaderLocalInput)obj;
            if (!Objects.equals((Object)this._dataStoreType, (Object)other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(this._shardName, other.getShardName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MakeLeaderLocalInputImpl otherImpl = (MakeLeaderLocalInputImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MakeLeaderLocalInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataStoreType", (Object)((Object)this._dataStoreType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardName", (Object)this._shardName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

