package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input input {
 *   leaf shard-prefix {
 *     type instance-identifier;
 *   }
 *   leaf data-store-type {
 *     type data-store-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/add-prefix-shard-replica/input</i>
 *
 * <p>To create instances of this class use {@link AddPrefixShardReplicaInputBuilder}.
 * @see AddPrefixShardReplicaInputBuilder
 *
 */
public interface AddPrefixShardReplicaInput
    extends
    RpcInput,
    Augmentable<AddPrefixShardReplicaInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaInput.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>shardPrefix</code>, or <code>null</code> if not present
     */
    @Nullable InstanceIdentifier<?> getShardPrefix();
    
    /**
     * The type of the data store to which the replica belongs
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType</code> <code>dataStoreType</code>, or <code>null</code> if not present
     */
    @Nullable DataStoreType getDataStoreType();

}

