package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link AddPrefixShardReplicaInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AddPrefixShardReplicaInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new AddPrefixShardReplicaInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AddPrefixShardReplicaInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AddPrefixShardReplicaInputBuilder
 * @see Builder
 *
 */
public class AddPrefixShardReplicaInputBuilder implements Builder<AddPrefixShardReplicaInput> {

    private DataStoreType _dataStoreType;
    private InstanceIdentifier<?> _shardPrefix;


    Map<Class<? extends Augmentation<AddPrefixShardReplicaInput>>, Augmentation<AddPrefixShardReplicaInput>> augmentation = Collections.emptyMap();

    public AddPrefixShardReplicaInputBuilder() {
    }

    public AddPrefixShardReplicaInputBuilder(AddPrefixShardReplicaInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AddPrefixShardReplicaInput>>, Augmentation<AddPrefixShardReplicaInput>> aug =((AugmentationHolder<AddPrefixShardReplicaInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardPrefix = base.getShardPrefix();
    }


    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public InstanceIdentifier<?> getShardPrefix() {
        return _shardPrefix;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddPrefixShardReplicaInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public AddPrefixShardReplicaInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public AddPrefixShardReplicaInputBuilder setShardPrefix(final InstanceIdentifier<?> value) {
        this._shardPrefix = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AddPrefixShardReplicaInputBuilder addAugmentation(Augmentation<AddPrefixShardReplicaInput> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public AddPrefixShardReplicaInputBuilder addAugmentation(Class<? extends Augmentation<AddPrefixShardReplicaInput>> augmentationType, Augmentation<AddPrefixShardReplicaInput> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AddPrefixShardReplicaInputBuilder removeAugmentation(Class<? extends Augmentation<AddPrefixShardReplicaInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private AddPrefixShardReplicaInputBuilder doAddAugmentation(Class<? extends Augmentation<AddPrefixShardReplicaInput>> augmentationType, Augmentation<AddPrefixShardReplicaInput> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public AddPrefixShardReplicaInput build() {
        return new AddPrefixShardReplicaInputImpl(this);
    }

    private static final class AddPrefixShardReplicaInputImpl
        extends AbstractAugmentable<AddPrefixShardReplicaInput>
        implements AddPrefixShardReplicaInput {
    
        private final DataStoreType _dataStoreType;
        private final InstanceIdentifier<?> _shardPrefix;
    
        AddPrefixShardReplicaInputImpl(AddPrefixShardReplicaInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardPrefix = base.getShardPrefix();
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public InstanceIdentifier<?> getShardPrefix() {
            return _shardPrefix;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_shardPrefix);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddPrefixShardReplicaInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            AddPrefixShardReplicaInput other = (AddPrefixShardReplicaInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_shardPrefix, other.getShardPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AddPrefixShardReplicaInputImpl otherImpl = (AddPrefixShardReplicaInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AddPrefixShardReplicaInput>>, Augmentation<AddPrefixShardReplicaInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AddPrefixShardReplicaInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_shardPrefix", _shardPrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
