package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ChangeMemberVotingStatesForAllShardsInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ChangeMemberVotingStatesForAllShardsInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ChangeMemberVotingStatesForAllShardsInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ChangeMemberVotingStatesForAllShardsInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ChangeMemberVotingStatesForAllShardsInputBuilder
 * @see Builder
 *
 */
public class ChangeMemberVotingStatesForAllShardsInputBuilder implements Builder<ChangeMemberVotingStatesForAllShardsInput> {

    private List<MemberVotingState> _memberVotingState;


    Map<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentation = Collections.emptyMap();

    public ChangeMemberVotingStatesForAllShardsInputBuilder() {
    }
    public ChangeMemberVotingStatesForAllShardsInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput arg) {
        this._memberVotingState = arg.getMemberVotingState();
    }

    public ChangeMemberVotingStatesForAllShardsInputBuilder(ChangeMemberVotingStatesForAllShardsInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> aug =((AugmentationHolder<ChangeMemberVotingStatesForAllShardsInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._memberVotingState = base.getMemberVotingState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput) {
            this._memberVotingState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput)arg).getMemberVotingState();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput]");
    }

    public List<MemberVotingState> getMemberVotingState() {
        return _memberVotingState;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ChangeMemberVotingStatesForAllShardsInputBuilder setMemberVotingState(final List<MemberVotingState> values) {
        this._memberVotingState = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ChangeMemberVotingStatesForAllShardsInputBuilder addAugmentation(Augmentation<ChangeMemberVotingStatesForAllShardsInput> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public ChangeMemberVotingStatesForAllShardsInputBuilder addAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentationType, Augmentation<ChangeMemberVotingStatesForAllShardsInput> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ChangeMemberVotingStatesForAllShardsInputBuilder removeAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private ChangeMemberVotingStatesForAllShardsInputBuilder doAddAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentationType, Augmentation<ChangeMemberVotingStatesForAllShardsInput> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public ChangeMemberVotingStatesForAllShardsInput build() {
        return new ChangeMemberVotingStatesForAllShardsInputImpl(this);
    }

    private static final class ChangeMemberVotingStatesForAllShardsInputImpl
        extends AbstractAugmentable<ChangeMemberVotingStatesForAllShardsInput>
        implements ChangeMemberVotingStatesForAllShardsInput {
    
        private final List<MemberVotingState> _memberVotingState;
    
        ChangeMemberVotingStatesForAllShardsInputImpl(ChangeMemberVotingStatesForAllShardsInputBuilder base) {
            super(base.augmentation);
            this._memberVotingState = CodeHelpers.emptyToNull(base.getMemberVotingState());
        }
    
        @Override
        public List<MemberVotingState> getMemberVotingState() {
            return _memberVotingState;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_memberVotingState);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ChangeMemberVotingStatesForAllShardsInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ChangeMemberVotingStatesForAllShardsInput other = (ChangeMemberVotingStatesForAllShardsInput)obj;
            if (!Objects.equals(_memberVotingState, other.getMemberVotingState())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChangeMemberVotingStatesForAllShardsInputImpl otherImpl = (ChangeMemberVotingStatesForAllShardsInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ChangeMemberVotingStatesForAllShardsInput");
            CodeHelpers.appendValue(helper, "_memberVotingState", _memberVotingState);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
