package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>cluster-admin</b>
 * <pre>
 * rpc add-shard-replica {
 *   input input {
 *     uses datastore-shard-id;
 *   }
 * }
 * rpc remove-shard-replica {
 *   input input {
 *     uses datastore-shard-id;
 *     leaf member-name {
 *       type string;
 *     }
 *   }
 * }
 * rpc make-leader-local {
 *   input input {
 *     uses datastore-shard-id;
 *   }
 * }
 * rpc add-prefix-shard-replica {
 *   input input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 * }
 * rpc remove-prefix-shard-replica {
 *   input input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf member-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 * }
 * rpc add-replicas-for-all-shards {
 *   output output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc remove-all-shard-replicas {
 *   input input {
 *     leaf member-name {
 *       type string;
 *     }
 *   }
 *   output output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc change-member-voting-states-for-shard {
 *   input input {
 *     uses datastore-shard-id;
 *     uses member-voting-states-input;
 *   }
 * }
 * rpc change-member-voting-states-for-all-shards {
 *   input input {
 *     uses member-voting-states-input;
 *   }
 *   output output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc flip-member-voting-states-for-all-shards {
 *   output output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc backup-datastore {
 *   input input {
 *     leaf file-path {
 *       type string;
 *     }
 *     leaf timeout {
 *       type uint32 {
 *         range 1..max;
 *       }
 *       units seconds;
 *     }
 *   }
 * }
 * rpc get-shard-role {
 *   input input {
 *     uses datastore-shard-id;
 *   }
 *   output output {
 *     leaf role {
 *       type string;
 *     }
 *   }
 * }
 * rpc locate-shard {
 *   input input {
 *     uses datastore-shard-id;
 *   }
 *   output output {
 *     choice member-node {
 *       case local {
 *         leaf local {
 *           type empty;
 *         }
 *       }
 *       case leader-actor-ref {
 *         leaf leader-actor-ref {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 * }
 * rpc get-prefix-shard-role {
 *   input input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output output {
 *     leaf role {
 *       type string;
 *     }
 *   }
 * }
 * rpc get-known-clients-for-all-shards {
 *   output output {
 *     uses shard-result-output {
 *       augment shard-result {
 *         list known-clients {
 *           when "../succeeded = true";
 *           uses cds:client-identifier;
 *           key "member type";
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface ClusterAdminService
    extends
    RpcService
{




    /**
     * Adds a replica of a shard to this node and joins it to an existing cluster. The
     * shard must already have a module configuration defined for it and there must
     * already be a shard existing on another node with a leader. This RPC first
     * contacts peer member seed nodes searching for a shard. When found, an AddServer
     * message is sent to the shard leader and applied as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddShardReplicaOutput>> addShardReplica(AddShardReplicaInput input);
    
    /**
     * Removes an existing replica of a shard from this node via the RemoveServer
     * mechanism as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveShardReplicaOutput>> removeShardReplica(RemoveShardReplicaInput input);
    
    /**
     * Attempts to move the shard leader of the given module based shard to the local
     * node. The rpc returns a response after handling of the underlying
     * MakeLeaderLocal message completes. This operation fails if there is no current
     * shard leader due to lack of network connectivity or a cluster majority. In
     * addition, if the local node is not up to date with the current leader, an
     * attempt is made to first sync the local node with the leader. If this cannot be
     * achieved within two election timeout periods the operation fails.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<MakeLeaderLocalOutput>> makeLeaderLocal(MakeLeaderLocalInput input);
    
    /**
     * Adds a replica of a shard to this node and joins it to an existing cluster.
     * There must already be a shard existing on another node with a leader. This RPC
     * first contacts peer member seed nodes searching for a shard. When found, an
     * AddServer message is sent to the shard leader and applied as described in the
     * Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddPrefixShardReplicaOutput>> addPrefixShardReplica(AddPrefixShardReplicaInput input);
    
    /**
     * Removes an existing replica of a prefix shard from this node via the
     * RemoveServer mechanism as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemovePrefixShardReplicaOutput>> removePrefixShardReplica(RemovePrefixShardReplicaInput input);
    
    /**
     * Adds replicas on this node for all currently defined shards. This is equivalent
     * to issuing an add-shard-replica RPC for all shards.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddReplicasForAllShardsOutput>> addReplicasForAllShards(AddReplicasForAllShardsInput input);
    
    /**
     * Removes replicas for all shards on this node. This is equivalent to issuing a
     * remove-shard-replica for all shards and essentially removes this node from a
     * cluster.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveAllShardReplicasOutput>> removeAllShardReplicas(RemoveAllShardReplicasInput input);
    
    /**
     * Changes the voting states, either voting or non-voting, of cluster members for a
     * shard. Non-voting members will no longer participate in leader elections and
     * consensus but will be replicated. This is useful for having a set of members
     * serve as a backup cluster in case the primary voting cluster suffers
     * catastrophic failure. This RPC can be issued to any cluster member and will be
     * forwarded to the leader.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<ChangeMemberVotingStatesForShardOutput>> changeMemberVotingStatesForShard(ChangeMemberVotingStatesForShardInput input);
    
    /**
     * Changes the voting states, either voting or non-voting, of cluster members for
     * all shards. Non-voting members will no longer participate in leader elections
     * and consensus but will be replicated. This is useful for having a set of members
     * serve as a backup cluster in case the primary voting cluster suffers
     * catastrophic failure. This RPC can be issued to any cluster member and will be
     * forwarded to the leader.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<ChangeMemberVotingStatesForAllShardsOutput>> changeMemberVotingStatesForAllShards(ChangeMemberVotingStatesForAllShardsInput input);
    
    /**
     * Flips the voting states of all cluster members for all shards, such that if a
     * member was voting it becomes non-voting and vice versa.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<FlipMemberVotingStatesForAllShardsOutput>> flipMemberVotingStatesForAllShards(FlipMemberVotingStatesForAllShardsInput input);
    
    /**
     * Creates a backup file of the datastore state
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<BackupDatastoreOutput>> backupDatastore(BackupDatastoreInput input);
    
    /**
     * Returns the current role for the requested module shard.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GetShardRoleOutput>> getShardRole(GetShardRoleInput input);
    
    /**
     * Return the transport-level information about where a shard has a home.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<LocateShardOutput>> locateShard(LocateShardInput input);
    
    /**
     * Returns the current role for the requested module shard.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GetPrefixShardRoleOutput>> getPrefixShardRole(GetPrefixShardRoleInput input);
    
    /**
     * Request all shards to report their known frontend clients. This is useful for
     * determining what generation should a resurrected member node should use.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GetKnownClientsForAllShardsOutput>> getKnownClientsForAllShards(GetKnownClientsForAllShardsInput input);

}

