package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum DataStoreType implements Enumeration {
    Config(1, "config"),
    
    Operational(2, "operational")
    ;

    private static final Map<String, DataStoreType> NAME_MAP;
    private static final Map<Integer, DataStoreType> VALUE_MAP;

    static {
        final Builder<String, DataStoreType> nb = ImmutableMap.builder();
        final Builder<Integer, DataStoreType> vb = ImmutableMap.builder();
        for (DataStoreType enumItem : DataStoreType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private DataStoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding DataStoreType item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<DataStoreType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding DataStoreType item, or null if no such item exists
     */
    public static DataStoreType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
