package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Grouping holding combined identifiers of a shard -- its name and datastore type
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * grouping datastore-shard-id {
 *   leaf shard-name {
 *     type string {
 *       length 1..max {
 *         error-app-tag odl-named-shards;
 *         error-message
 *           "Shard name must not be empty";
 *       }
 *     }
 *   }
 *   leaf data-store-type {
 *     type data-store-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/datastore-shard-id</i>
 *
 */
public interface DatastoreShardId
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("datastore-shard-id");

    @Override
    Class<? extends DatastoreShardId> implementedInterface();
    
    /**
     * The name of the shard.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>shardName</code>, or <code>null</code> if not present
     */
    @Nullable String getShardName();
    
    /**
     * The type of the data store to which the shard belongs
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType</code> <code>dataStoreType</code>, or <code>null</code> if not present
     */
    @Nullable DataStoreType getDataStoreType();

}

