package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * output output {
 *   uses shard-result-output {
 *     augment shard-result {
 *       list known-clients {
 *         when "../succeeded = true";
 *         uses cds:client-identifier;
 *         key "member type";
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/get-known-clients-for-all-shards/output</i>
 *
 * <p>To create instances of this class use {@link GetKnownClientsForAllShardsOutputBuilder}.
 * @see GetKnownClientsForAllShardsOutputBuilder
 *
 */
public interface GetKnownClientsForAllShardsOutput
    extends
    ShardResultOutput,
    RpcOutput,
    Augmentable<GetKnownClientsForAllShardsOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetKnownClientsForAllShardsOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetKnownClientsForAllShardsOutput.class;
    }

}

