package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * output output {
 *   leaf role {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/get-prefix-shard-role/output</i>
 *
 * <p>To create instances of this class use {@link GetPrefixShardRoleOutputBuilder}.
 * @see GetPrefixShardRoleOutputBuilder
 *
 */
public interface GetPrefixShardRoleOutput
    extends
    RpcOutput,
    Augmentable<GetPrefixShardRoleOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutput.class;
    }
    
    /**
     * Current role for the given shard, if not present the shard currently does not
     * have a role
     *
     *
     *
     * @return <code>java.lang.String</code> <code>role</code>, or <code>null</code> if not present
     */
    @Nullable String getRole();

}

