package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.locate.shard.output.MemberNode;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * output output {
 *   choice member-node {
 *     case local {
 *       leaf local {
 *         type empty;
 *       }
 *     }
 *     case leader-actor-ref {
 *       leaf leader-actor-ref {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/locate-shard/output</i>
 *
 * <p>To create instances of this class use {@link LocateShardOutputBuilder}.
 * @see LocateShardOutputBuilder
 *
 */
public interface LocateShardOutput
    extends
    RpcOutput,
    Augmentable<LocateShardOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardOutput.class;
    }
    
    /**
     * Location of the hypothetical cluster member node. Relationship to the input
     * parameters and the transport protocol.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.locate.shard.output.MemberNode</code> <code>memberNode</code>, or <code>null</code> if not present
     */
    @Nullable MemberNode getMemberNode();

}

