package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input input {
 *   uses datastore-shard-id;
 *   leaf member-name {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/remove-shard-replica/input</i>
 *
 * <p>To create instances of this class use {@link RemoveShardReplicaInputBuilder}.
 * @see RemoveShardReplicaInputBuilder
 *
 */
public interface RemoveShardReplicaInput
    extends
    DatastoreShardId,
    RpcInput,
    Augmentable<RemoveShardReplicaInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaInput.class;
    }
    
    /**
     * The cluster member from which the shard replica should be removed
     *
     *
     *
     * @return <code>java.lang.String</code> <code>memberName</code>, or <code>null</code> if not present
     */
    @Nullable String getMemberName();

}

