package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.get.known.clients._for.all.shards.output.shard.result;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.FrontendType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.MemberName;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class KnownClientsKey
 implements Identifier<KnownClients> {
    private static final long serialVersionUID = 3739296484222449166L;
    private final MemberName _member;
    private final FrontendType _type;


    public KnownClientsKey(MemberName _member, FrontendType _type) {
    
        this._member = _member;
        this._type = _type;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public KnownClientsKey(KnownClientsKey source) {
        this._member = source._member;
        this._type = source._type;
    }


    public MemberName getMember() {
        return _member;
    }
    
    public FrontendType getType() {
        return _type;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_member);
        result = prime * result + Objects.hashCode(_type);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KnownClientsKey)) {
            return false;
        }
        final KnownClientsKey other = (KnownClientsKey) obj;
        if (!Objects.equals(_member, other._member)) {
            return false;
        }
        if (!Objects.equals(_type, other._type)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(KnownClientsKey.class);
        CodeHelpers.appendValue(helper, "_member", _member);
        CodeHelpers.appendValue(helper, "_type", _type);
        return helper.toString();
    }
}

