package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The list of results, one per shard
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * list shard-result {
 *   key "shard-name data-store-type";
 *   uses shard-operation-result;
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/shard-result-output/shard-result</i>
 *
 * <p>To create instances of this class use {@link ShardResultBuilder}.
 * @see ShardResultBuilder
 * @see ShardResultKey
 *
 */
public interface ShardResult
    extends
    ChildOf<ShardResultOutput>,
    Augmentable<ShardResult>,
    ShardOperationResult,
    Identifiable<ShardResultKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("shard-result");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult.class;
    }
    
    @Override
    ShardResultKey key();

}

