package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class ShardResultKey
 implements Identifier<ShardResult> {
    private static final long serialVersionUID = 2466758623132491266L;
    private final String _shardName;
    private final DataStoreType _dataStoreType;


    public ShardResultKey(DataStoreType _dataStoreType, String _shardName) {
    
        this._shardName = _shardName;
        this._dataStoreType = _dataStoreType;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ShardResultKey(ShardResultKey source) {
        this._shardName = source._shardName;
        this._dataStoreType = source._dataStoreType;
    }


    public String getShardName() {
        return _shardName;
    }
    
    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_shardName);
        result = prime * result + Objects.hashCode(_dataStoreType);
        return result;
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShardResultKey)) {
            return false;
        }
        final ShardResultKey other = (ShardResultKey) obj;
        if (!Objects.equals(_shardName, other._shardName)) {
            return false;
        }
        if (!Objects.equals(_dataStoreType, other._dataStoreType)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ShardResultKey.class);
        CodeHelpers.appendValue(helper, "_shardName", _shardName);
        CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
        return helper.toString();
    }
}

