/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LocateShardInputBuilder
implements Builder<LocateShardInput> {
    private DataStoreType _dataStoreType;
    private String _shardName;
    Map<Class<? extends Augmentation<LocateShardInput>>, Augmentation<LocateShardInput>> augmentation = Collections.emptyMap();

    public LocateShardInputBuilder() {
    }

    public LocateShardInputBuilder(DatastoreShardId arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public LocateShardInputBuilder(LocateShardInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocateShardInput>>, Augmentation<LocateShardInput>>(aug);
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DatastoreShardId) {
            this._shardName = ((DatastoreShardId)arg).getShardName();
            this._dataStoreType = ((DatastoreShardId)arg).getDataStoreType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[DatastoreShardId]");
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getShardName() {
        return this._shardName;
    }

    public <E$$ extends Augmentation<LocateShardInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public LocateShardInputBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    private static void check_shardNameLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public LocateShardInputBuilder setShardName(String value) {
        if (value != null) {
            LocateShardInputBuilder.check_shardNameLength(value);
        }
        this._shardName = value;
        return this;
    }

    public LocateShardInputBuilder addAugmentation(Augmentation<LocateShardInput> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocateShardInput>>, Augmentation<LocateShardInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LocateShardInputBuilder removeAugmentation(Class<? extends Augmentation<LocateShardInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LocateShardInput build() {
        return new LocateShardInputImpl(this);
    }

    private static final class LocateShardInputImpl
    extends AbstractAugmentable<LocateShardInput>
    implements LocateShardInput {
        private final DataStoreType _dataStoreType;
        private final String _shardName;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LocateShardInputImpl(LocateShardInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardName = base.getShardName();
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = LocateShardInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return LocateShardInput.bindingEquals(this, obj);
        }

        public String toString() {
            return LocateShardInput.bindingToString(this);
        }
    }
}

