/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.admin;

import akka.actor.ActorRef;
import akka.actor.Status;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.messages.AddPrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.AddShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ChangeShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.FlipShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRole;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRoleReply;
import org.opendaylight.controller.cluster.datastore.messages.MakeLeaderLocal;
import org.opendaylight.controller.cluster.datastore.messages.RemovePrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.RemoveShardReplica;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshotList;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshot;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddReplicasForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddReplicasForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.FlipMemberVotingStatesForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.FlipMemberVotingStatesForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemovePrefixShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResultBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Promise;

public class ClusterAdminRpcService
implements ClusterAdminService {
    private static final Timeout SHARD_MGR_TIMEOUT = new Timeout(1L, TimeUnit.MINUTES);
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAdminRpcService.class);
    private final DistributedDataStoreInterface configDataStore;
    private final DistributedDataStoreInterface operDataStore;
    private final BindingNormalizedNodeSerializer serializer;
    private final Timeout makeLeaderLocalTimeout;

    public ClusterAdminRpcService(DistributedDataStoreInterface configDataStore, DistributedDataStoreInterface operDataStore, BindingNormalizedNodeSerializer serializer) {
        this.configDataStore = configDataStore;
        this.operDataStore = operDataStore;
        this.serializer = serializer;
        this.makeLeaderLocalTimeout = new Timeout(configDataStore.getActorContext().getDatastoreContext().getShardLeaderElectionTimeout().duration().$times(2L));
    }

    public Future<RpcResult<Void>> addShardReplica(AddShardReplicaInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Adding replica for shard {}", (Object)shardName);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new AddShardReplica(shardName));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully added replica for shard {}", (Object)shardName);
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult());
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to add replica for shard %s", shardName), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<Void>> removeShardReplica(RemoveShardReplicaInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        LOG.info("Removing replica for shard {} memberName {}, datastoreType {}", new Object[]{shardName, memberName, dataStoreType});
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new RemoveShardReplica(shardName, MemberName.forName((String)memberName)));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully removed replica for shard {}", (Object)shardName);
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult());
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to remove replica for shard %s", shardName), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<Void>> makeLeaderLocal(MakeLeaderLocalInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        final ActorContext actorContext = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorContext() : this.operDataStore.getActorContext();
        LOG.info("Moving leader to local node {} for shard {}, datastoreType {}", new Object[]{actorContext.getCurrentMemberName().getName(), shardName, dataStoreType});
        scala.concurrent.Future localShardReply = actorContext.findLocalShardAsync(shardName);
        final Promise makeLeaderLocalAsk = Futures.promise();
        localShardReply.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef actorRef) throws Throwable {
                if (failure != null) {
                    LOG.warn("No local shard found for {} datastoreType {} - Cannot request leadership transfer to local shard.", (Object)shardName, (Object)failure);
                    makeLeaderLocalAsk.failure(failure);
                } else {
                    makeLeaderLocalAsk.completeWith(actorContext.executeOperationAsync(actorRef, (Object)MakeLeaderLocal.INSTANCE, ClusterAdminRpcService.this.makeLeaderLocalTimeout));
                }
            }
        }, actorContext.getClientDispatcher());
        final SettableFuture future = SettableFuture.create();
        makeLeaderLocalAsk.future().onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) throws Throwable {
                if (failure != null) {
                    LOG.error("Leadership transfer failed for shard {}.", (Object)shardName, (Object)failure);
                    future.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "leadership transfer failed", failure).build());
                    return;
                }
                LOG.debug("Leadership transfer complete");
                future.set((Object)RpcResultBuilder.success().build());
            }
        }, actorContext.getClientDispatcher());
        return future;
    }

    public Future<RpcResult<Void>> addPrefixShardReplica(AddPrefixShardReplicaInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Adding replica for shard {}, datastore type {}", (Object)identifier, (Object)dataStoreType);
        final YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new AddPrefixShardReplica(prefix));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully added replica for shard {}", (Object)prefix);
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult());
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to add replica for shard %s", prefix), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<Void>> removePrefixShardReplica(RemovePrefixShardReplicaInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        LOG.info("Removing replica for shard {} memberName {}, datastoreType {}", new Object[]{identifier, memberName, dataStoreType});
        final YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new RemovePrefixShardReplica(prefix, MemberName.forName((String)memberName)));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully removed replica for shard {}", (Object)prefix);
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult());
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to remove replica for shard %s", prefix), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<AddReplicasForAllShardsOutput>> addReplicasForAllShards() {
        LOG.info("Adding replicas for all shards");
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function messageSupplier = shardName -> new AddShardReplica(shardName);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, (Function<String, Object>)messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, (Function<String, Object>)messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new AddReplicasForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to add replica");
    }

    public Future<RpcResult<RemoveAllShardReplicasOutput>> removeAllShardReplicas(RemoveAllShardReplicasInput input) {
        LOG.info("Removing replicas for all shards");
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function messageSupplier = shardName -> new RemoveShardReplica(shardName, MemberName.forName((String)memberName));
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, (Function<String, Object>)messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, (Function<String, Object>)messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new RemoveAllShardReplicasOutputBuilder().setShardResult(shardResults).build(), "       Failed to remove replica");
    }

    public Future<RpcResult<Void>> changeMemberVotingStatesForShard(ChangeMemberVotingStatesForShardInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        List memberVotingStates = input.getMemberVotingState();
        if (memberVotingStates == null || memberVotingStates.isEmpty()) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("No member voting state input was specified");
        }
        ChangeShardMembersVotingStatus changeVotingStatus = this.toChangeShardMembersVotingStatus(shardName, memberVotingStates);
        LOG.info("Change member voting states for shard {}: {}", (Object)shardName, (Object)changeVotingStatus.getMeberVotingStatusMap());
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, changeVotingStatus);
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully changed member voting states for shard {}", (Object)shardName);
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult());
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to change member voting states for shard %s", shardName), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<ChangeMemberVotingStatesForAllShardsOutput>> changeMemberVotingStatesForAllShards(ChangeMemberVotingStatesForAllShardsInput input) {
        List memberVotingStates = input.getMemberVotingState();
        if (memberVotingStates == null || memberVotingStates.isEmpty()) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("No member voting state input was specified");
        }
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function messageSupplier = shardName -> this.toChangeShardMembersVotingStatus((String)shardName, memberVotingStates);
        LOG.info("Change member voting states for all shards");
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, (Function<String, Object>)messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, (Function<String, Object>)messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new ChangeMemberVotingStatesForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to change member voting states");
    }

    public Future<RpcResult<FlipMemberVotingStatesForAllShardsOutput>> flipMemberVotingStatesForAllShards() {
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function messageSupplier = shardName -> new FlipShardMembersVotingStatus(shardName);
        LOG.info("Flip member voting states for all shards");
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, (Function<String, Object>)messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, (Function<String, Object>)messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new FlipMemberVotingStatesForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to change member voting states");
    }

    public Future<RpcResult<GetShardRoleOutput>> getShardRole(GetShardRoleInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Getting role for shard {}, datastore type {}", (Object)shardName, (Object)dataStoreType);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new GetShardRole(shardName));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<GetShardRoleReply>(){

            public void onSuccess(GetShardRoleReply reply) {
                if (reply == null) {
                    returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("No Shard role present. Please retry..").build());
                    return;
                }
                LOG.info("Successfully received role:{} for shard {}", (Object)reply.getRole(), (Object)shardName);
                GetShardRoleOutputBuilder builder = new GetShardRoleOutputBuilder();
                if (reply.getRole() != null) {
                    builder.setRole(reply.getRole());
                }
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult(builder.build()));
            }

            public void onFailure(Throwable failure) {
                returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("Failed to get shard role.", failure).build());
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<GetPrefixShardRoleOutput>> getPrefixShardRole(GetPrefixShardRoleInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Getting prefix shard role for shard: {}, datastore type {}", (Object)identifier, (Object)dataStoreType);
        YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final String shardName = ClusterUtils.getCleanShardName((YangInstanceIdentifier)prefix);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new GetShardRole(shardName));
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<GetShardRoleReply>(){

            public void onSuccess(GetShardRoleReply reply) {
                if (reply == null) {
                    returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("No Shard role present. Please retry..").build());
                    return;
                }
                LOG.info("Successfully received role:{} for shard {}", (Object)reply.getRole(), (Object)shardName);
                GetPrefixShardRoleOutputBuilder builder = new GetPrefixShardRoleOutputBuilder();
                if (reply.getRole() != null) {
                    builder.setRole(reply.getRole());
                }
                returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult(builder.build()));
            }

            public void onFailure(Throwable failure) {
                returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("Failed to get shard role.", failure).build());
            }
        });
        return returnFuture;
    }

    public Future<RpcResult<Void>> backupDatastore(final BackupDatastoreInput input) {
        LOG.debug("backupDatastore: {}", (Object)input);
        if (Strings.isNullOrEmpty((String)input.getFilePath())) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid file path must be specified");
        }
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManagers(GetSnapshot.INSTANCE);
        com.google.common.util.concurrent.Futures.addCallback(future, (FutureCallback)new FutureCallback<List<DatastoreSnapshot>>(){

            public void onSuccess(List<DatastoreSnapshot> snapshots) {
                ClusterAdminRpcService.saveSnapshotsToFile(new DatastoreSnapshotList(snapshots), input.getFilePath(), (SettableFuture<RpcResult<Void>>)returnFuture);
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onDatastoreBackupFailure(input.getFilePath(), (SettableFuture<RpcResult<Void>>)returnFuture, failure);
            }
        });
        return returnFuture;
    }

    private ChangeShardMembersVotingStatus toChangeShardMembersVotingStatus(String shardName, List<MemberVotingState> memberVotingStatus) {
        HashMap<String, Boolean> serverVotingStatusMap = new HashMap<String, Boolean>();
        for (MemberVotingState memberStatus : memberVotingStatus) {
            serverVotingStatusMap.put(memberStatus.getMemberName(), memberStatus.isVoting());
        }
        ChangeShardMembersVotingStatus changeVotingStatus = new ChangeShardMembersVotingStatus(shardName, serverVotingStatusMap);
        return changeVotingStatus;
    }

    private static <T> SettableFuture<RpcResult<T>> waitForShardResults(final List<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData, final Function<List<ShardResult>, T> resultDataSupplier, final String failureLogMsgPrefix) {
        final SettableFuture returnFuture = SettableFuture.create();
        final ArrayList shardResults = new ArrayList();
        for (final Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder> entry : shardResultData) {
            com.google.common.util.concurrent.Futures.addCallback(entry.getKey(), (FutureCallback)new FutureCallback<Status.Success>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Status.Success result) {
                    List list = shardResults;
                    synchronized (list) {
                        ShardResultBuilder shardResult = (ShardResultBuilder)entry.getValue();
                        LOG.debug("onSuccess for shard {}, type {}", (Object)shardResult.getShardName(), (Object)shardResult.getDataStoreType());
                        shardResults.add(shardResult.setSucceeded(Boolean.valueOf(true)).build());
                        this.checkIfComplete();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable failure) {
                    List list = shardResults;
                    synchronized (list) {
                        ShardResultBuilder shardResult = (ShardResultBuilder)entry.getValue();
                        LOG.warn("{} for shard {}, type {}", new Object[]{failureLogMsgPrefix, shardResult.getShardName(), shardResult.getDataStoreType(), failure});
                        shardResults.add(shardResult.setSucceeded(Boolean.valueOf(false)).setErrorMessage(Throwables.getRootCause((Throwable)failure).getMessage()).build());
                        this.checkIfComplete();
                    }
                }

                void checkIfComplete() {
                    LOG.debug("checkIfComplete: expected {}, actual {}", (Object)shardResultData.size(), (Object)shardResults.size());
                    if (shardResults.size() == shardResultData.size()) {
                        returnFuture.set((Object)ClusterAdminRpcService.newSuccessfulResult(resultDataSupplier.apply((Object)shardResults)));
                    }
                }
            });
        }
        return returnFuture;
    }

    private <T> void sendMessageToManagerForConfiguredShards(DataStoreType dataStoreType, List<Map.Entry<ListenableFuture<T>, ShardResultBuilder>> shardResultData, Function<String, Object> messageSupplier) {
        ActorContext actorContext = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorContext() : this.operDataStore.getActorContext();
        Set allShardNames = actorContext.getConfiguration().getAllShardNames();
        LOG.debug("Sending message to all shards {} for data store {}", (Object)allShardNames, (Object)actorContext.getDataStoreName());
        for (String shardName : allShardNames) {
            ListenableFuture<T> future = this.ask(actorContext.getShardManager(), messageSupplier.apply((Object)shardName), SHARD_MGR_TIMEOUT);
            shardResultData.add(new AbstractMap.SimpleEntry<ListenableFuture<T>, ShardResultBuilder>(future, new ShardResultBuilder().setShardName(shardName).setDataStoreType(dataStoreType)));
        }
    }

    private <T> ListenableFuture<List<T>> sendMessageToShardManagers(Object message) {
        Timeout timeout = SHARD_MGR_TIMEOUT;
        ListenableFuture<T> configFuture = this.ask(this.configDataStore.getActorContext().getShardManager(), message, timeout);
        ListenableFuture<T> operFuture = this.ask(this.operDataStore.getActorContext().getShardManager(), message, timeout);
        return com.google.common.util.concurrent.Futures.allAsList((ListenableFuture[])new ListenableFuture[]{configFuture, operFuture});
    }

    private <T> ListenableFuture<T> sendMessageToShardManager(DataStoreType dataStoreType, Object message) {
        ActorRef shardManager = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorContext().getShardManager() : this.operDataStore.getActorContext().getShardManager();
        return this.ask(shardManager, message, SHARD_MGR_TIMEOUT);
    }

    private static void saveSnapshotsToFile(DatastoreSnapshotList snapshots, String fileName, SettableFuture<RpcResult<Void>> returnFuture) {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            SerializationUtils.serialize((Serializable)snapshots, (OutputStream)fos);
            returnFuture.set(ClusterAdminRpcService.newSuccessfulResult());
            LOG.info("Successfully backed up datastore to file {}", (Object)fileName);
        }
        catch (IOException | RuntimeException e) {
            ClusterAdminRpcService.onDatastoreBackupFailure(fileName, returnFuture, e);
        }
    }

    private static void onDatastoreBackupFailure(String fileName, SettableFuture<RpcResult<Void>> returnFuture, Throwable failure) {
        ClusterAdminRpcService.onMessageFailure(String.format("Failed to back up datastore to file %s", fileName), returnFuture, failure);
    }

    private static void onMessageFailure(String msg, SettableFuture<RpcResult<Void>> returnFuture, Throwable failure) {
        LOG.error(msg, failure);
        returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder(String.format("%s: %s", msg, failure.getMessage())).build());
    }

    private <T> ListenableFuture<T> ask(ActorRef actor, Object message, Timeout timeout) {
        final SettableFuture returnFuture = SettableFuture.create();
        scala.concurrent.Future askFuture = Patterns.ask((ActorRef)actor, (Object)message, (Timeout)timeout);
        askFuture.onComplete((Function1)new OnComplete<T>(){

            public void onComplete(Throwable failure, T resp) {
                if (failure != null) {
                    returnFuture.setException(failure);
                } else {
                    returnFuture.set(resp);
                }
            }
        }, this.configDataStore.getActorContext().getClientDispatcher());
        return returnFuture;
    }

    private static <T> ListenableFuture<RpcResult<T>> newFailedRpcResultFuture(String message) {
        return ClusterAdminRpcService.newFailedRpcResultBuilder(message).buildFuture();
    }

    private static <T> RpcResultBuilder<T> newFailedRpcResultBuilder(String message) {
        return ClusterAdminRpcService.newFailedRpcResultBuilder(message, null);
    }

    private static <T> RpcResultBuilder<T> newFailedRpcResultBuilder(String message, Throwable cause) {
        return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, message, cause);
    }

    private static RpcResult<Void> newSuccessfulResult() {
        return ClusterAdminRpcService.newSuccessfulResult(null);
    }

    private static <T> RpcResult<T> newSuccessfulResult(T data) {
        return RpcResultBuilder.success(data).build();
    }
}

