/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.cluster_admin_provider;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.config.cluster_admin_provider.ClusterAdminProviderModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.core.spi.config_dom_store.DOMStoreServiceInterface;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:config:cluster-admin-provider", name="cluster-admin-provider", revision="2015-10-13")
public abstract class AbstractClusterAdminProviderModule
extends AbstractModule<AbstractClusterAdminProviderModule>
implements ClusterAdminProviderModuleMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClusterAdminProviderModule.class);
    public static final JmxAttribute configDataStoreJmxAttribute = new JmxAttribute("ConfigDataStore");
    private ObjectName configDataStore;
    public static final JmxAttribute rpcRegistryJmxAttribute = new JmxAttribute("RpcRegistry");
    private ObjectName rpcRegistry;
    public static final JmxAttribute operDataStoreJmxAttribute = new JmxAttribute("OperDataStore");
    private ObjectName operDataStore;
    private DOMStore configDataStoreDependency;
    private RpcProviderRegistry rpcRegistryDependency;
    private DOMStore operDataStoreDependency;

    public AbstractClusterAdminProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractClusterAdminProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractClusterAdminProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.configDataStore != null) {
            this.dependencyResolver.validateDependency(DOMStoreServiceInterface.class, this.configDataStore, configDataStoreJmxAttribute);
        }
        if (this.rpcRegistry != null) {
            this.dependencyResolver.validateDependency(RpcProviderRegistryServiceInterface.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        }
        if (this.operDataStore != null) {
            this.dependencyResolver.validateDependency(org.opendaylight.controller.config.yang.md.sal.core.spi.operational_dom_store.DOMStoreServiceInterface.class, this.operDataStore, operDataStoreJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final DOMStore getConfigDataStoreDependency() {
        return this.configDataStoreDependency;
    }

    protected final RpcProviderRegistry getRpcRegistryDependency() {
        return this.rpcRegistryDependency;
    }

    protected final DOMStore getOperDataStoreDependency() {
        return this.operDataStoreDependency;
    }

    protected final void resolveDependencies() {
        if (this.rpcRegistry != null) {
            this.rpcRegistryDependency = (RpcProviderRegistry)this.dependencyResolver.resolveInstance(RpcProviderRegistry.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        }
        if (this.configDataStore != null) {
            this.configDataStoreDependency = (DOMStore)this.dependencyResolver.resolveInstance(DOMStore.class, this.configDataStore, configDataStoreJmxAttribute);
        }
        if (this.operDataStore != null) {
            this.operDataStoreDependency = (DOMStore)this.dependencyResolver.resolveInstance(DOMStore.class, this.operDataStore, operDataStoreJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractClusterAdminProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractClusterAdminProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.configDataStore, other.configDataStore)) {
            return false;
        }
        if (this.configDataStore != null && !this.dependencyResolver.canReuseDependency(this.configDataStore, configDataStoreJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.rpcRegistry, other.rpcRegistry)) {
            return false;
        }
        if (this.rpcRegistry != null && !this.dependencyResolver.canReuseDependency(this.rpcRegistry, rpcRegistryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.operDataStore, other.operDataStore)) {
            return false;
        }
        return this.operDataStore == null || this.dependencyResolver.canReuseDependency(this.operDataStore, operDataStoreJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClusterAdminProviderModule that = (AbstractClusterAdminProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getConfigDataStore() {
        return this.configDataStore;
    }

    @Override
    @RequireInterface(value=DOMStoreServiceInterface.class)
    public void setConfigDataStore(ObjectName configDataStore) {
        this.configDataStore = configDataStore;
    }

    @Override
    public ObjectName getRpcRegistry() {
        return this.rpcRegistry;
    }

    @Override
    @RequireInterface(value=RpcProviderRegistryServiceInterface.class)
    public void setRpcRegistry(ObjectName rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }

    @Override
    public ObjectName getOperDataStore() {
        return this.operDataStore;
    }

    @Override
    @RequireInterface(value=org.opendaylight.controller.config.yang.md.sal.core.spi.operational_dom_store.DOMStoreServiceInterface.class)
    public void setOperDataStore(ObjectName operDataStore) {
        this.operDataStore = operDataStore;
    }

    public Logger getLogger() {
        return LOG;
    }
}

