/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.cluster.admin.provider.rev151013.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.cluster.admin.provider.rev151013.modules.module.configuration.ClusterAdminProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.cluster.admin.provider.rev151013.modules.module.configuration.cluster.admin.provider.ConfigDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.cluster.admin.provider.rev151013.modules.module.configuration.cluster.admin.provider.OperDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.cluster.admin.provider.rev151013.modules.module.configuration.cluster.admin.provider.RpcRegistry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClusterAdminProviderBuilder
implements Builder<ClusterAdminProvider> {
    private ConfigDataStore _configDataStore;
    private OperDataStore _operDataStore;
    private RpcRegistry _rpcRegistry;
    Map<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>> augmentation = Collections.emptyMap();

    public ClusterAdminProviderBuilder() {
    }

    public ClusterAdminProviderBuilder(ClusterAdminProvider base) {
        AugmentationHolder casted;
        this._configDataStore = base.getConfigDataStore();
        this._operDataStore = base.getOperDataStore();
        this._rpcRegistry = base.getRpcRegistry();
        if (base instanceof ClusterAdminProviderImpl) {
            ClusterAdminProviderImpl impl = (ClusterAdminProviderImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>>(casted.augmentations());
        }
    }

    public ConfigDataStore getConfigDataStore() {
        return this._configDataStore;
    }

    public OperDataStore getOperDataStore() {
        return this._operDataStore;
    }

    public RpcRegistry getRpcRegistry() {
        return this._rpcRegistry;
    }

    public <E extends Augmentation<ClusterAdminProvider>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ClusterAdminProviderBuilder setConfigDataStore(ConfigDataStore value) {
        this._configDataStore = value;
        return this;
    }

    public ClusterAdminProviderBuilder setOperDataStore(OperDataStore value) {
        this._operDataStore = value;
        return this;
    }

    public ClusterAdminProviderBuilder setRpcRegistry(RpcRegistry value) {
        this._rpcRegistry = value;
        return this;
    }

    public ClusterAdminProviderBuilder addAugmentation(Class<? extends Augmentation<ClusterAdminProvider>> augmentationType, Augmentation<ClusterAdminProvider> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ClusterAdminProviderBuilder removeAugmentation(Class<? extends Augmentation<ClusterAdminProvider>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ClusterAdminProvider build() {
        return new ClusterAdminProviderImpl(this);
    }

    private static final class ClusterAdminProviderImpl
    implements ClusterAdminProvider {
        private final ConfigDataStore _configDataStore;
        private final OperDataStore _operDataStore;
        private final RpcRegistry _rpcRegistry;
        private Map<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ClusterAdminProvider> getImplementedInterface() {
            return ClusterAdminProvider.class;
        }

        private ClusterAdminProviderImpl(ClusterAdminProviderBuilder base) {
            this._configDataStore = base.getConfigDataStore();
            this._operDataStore = base.getOperDataStore();
            this._rpcRegistry = base.getRpcRegistry();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>>(base.augmentation);
                }
            }
        }

        @Override
        public ConfigDataStore getConfigDataStore() {
            return this._configDataStore;
        }

        @Override
        public OperDataStore getOperDataStore() {
            return this._operDataStore;
        }

        @Override
        public RpcRegistry getRpcRegistry() {
            return this._rpcRegistry;
        }

        public <E extends Augmentation<ClusterAdminProvider>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._configDataStore);
            result = 31 * result + Objects.hashCode(this._operDataStore);
            result = 31 * result + Objects.hashCode(this._rpcRegistry);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ClusterAdminProvider.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ClusterAdminProvider other = (ClusterAdminProvider)obj;
            if (!Objects.equals(this._configDataStore, other.getConfigDataStore())) {
                return false;
            }
            if (!Objects.equals(this._operDataStore, other.getOperDataStore())) {
                return false;
            }
            if (!Objects.equals(this._rpcRegistry, other.getRpcRegistry())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ClusterAdminProviderImpl otherImpl = (ClusterAdminProviderImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ClusterAdminProvider>>, Augmentation<ClusterAdminProvider>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ClusterAdminProvider [";
            StringBuilder builder = new StringBuilder(name);
            if (this._configDataStore != null) {
                builder.append("_configDataStore=");
                builder.append(this._configDataStore);
                builder.append(", ");
            }
            if (this._operDataStore != null) {
                builder.append("_operDataStore=");
                builder.append(this._operDataStore);
                builder.append(", ");
            }
            if (this._rpcRegistry != null) {
                builder.append("_rpcRegistry=");
                builder.append(this._rpcRegistry);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

