/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.admin;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yangtools.concepts.Identifier;

final class ShardIdentifier
implements Identifier {
    private static final long serialVersionUID = 1L;
    private final @NonNull String shardName;
    private final @NonNull DataStoreType type;

    ShardIdentifier(DataStoreType type, String shardName) {
        this.type = Objects.requireNonNull(type);
        this.shardName = Objects.requireNonNull(shardName);
    }

    ShardIdentifier(DatastoreShardId id) {
        this(id.getDataStoreType(), id.getShardName());
    }

    public @NonNull String getShardName() {
        return this.shardName;
    }

    public @NonNull DataStoreType getDataStoreType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + this.shardName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShardIdentifier)) {
            return false;
        }
        ShardIdentifier other = (ShardIdentifier)obj;
        return this.type.equals((Object)other.type) && this.shardName.equals(other.shardName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("shardName", (Object)this.shardName).toString();
    }
}

