/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.admin;

import com.google.common.annotations.Beta;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.admin.ClusterAdminRpcService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public final class OSGiClusterAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiClusterAdmin.class);
    @Reference(target="(type=distributed-config)")
    DistributedDataStoreInterface configDatastore = null;
    @Reference(target="(type=distributed-operational)")
    DistributedDataStoreInterface operDatastore = null;
    @Reference
    BindingNormalizedNodeSerializer serializer = null;
    @Reference
    RpcProviderService rpcProviderService = null;
    private ObjectRegistration<?> reg;

    @Activate
    void activate() {
        this.reg = this.rpcProviderService.registerRpcImplementation(ClusterAdminService.class, (RpcService)new ClusterAdminRpcService(this.configDatastore, this.operDatastore, this.serializer));
        LOG.info("Cluster Admin services started");
    }

    @Deactivate
    void deactivate() {
        this.reg.close();
        LOG.info("Cluster Admin services stopped");
    }
}

