package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.core.general.entity.rev150820;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import java.util.List;

/**
 * Defines a model to describe a general entity whose path can be used as an ID 
 * an entity that isn't otherwise modelled
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>general-entity</b>
 * <pre>
 * module general-entity {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:controller:md:sal:core:general-entity";
 *     prefix "general-entity";
 *
 *     revision 2015-08-20 {
 *         description "Defines a model to describe a general entity whose path can be used as an ID 
 *                     an entity that isn't otherwise modelled
 *         ";
 *     }
 *
 *     list entity {
 *         key "name"
 *         leaf name {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface GeneralEntityData
    extends
    DataRoot
{




    /**
     * @return <code>java.util.List</code> <code>entity</code>, or <code>null</code> if not present
     */
    List<Entity> getEntity();

}

