/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.util.jmx;

import com.google.common.annotations.Beta;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMXBean.class);
    public static final String BASE_JMX_PREFIX = "org.opendaylight.controller:";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String beanName;
    private final String beanType;
    private final String beanCategory;

    protected AbstractMXBean(@Nonnull String beanName, @Nonnull String beanType, @Nullable String beanCategory) {
        this.beanName = beanName;
        this.beanType = beanType;
        this.beanCategory = beanCategory;
    }

    private ObjectName getMBeanObjectName() throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder(BASE_JMX_PREFIX).append("type=").append(this.getMBeanType());
        if (this.getMBeanCategory() != null) {
            builder.append(",Category=").append(this.getMBeanCategory());
        }
        builder.append(",name=").append(this.getMBeanName());
        return new ObjectName(builder.toString());
    }

    public void register() {
        this.registerMBean();
    }

    public boolean registerMBean() {
        boolean registered = false;
        try {
            ObjectName mbeanName = this.getMBeanObjectName();
            LOG.debug("Register MBean {}", (Object)mbeanName);
            if (this.server.isRegistered(mbeanName)) {
                LOG.debug("MBean {} found to be already registered", (Object)mbeanName);
                try {
                    this.unregisterMBean(mbeanName);
                }
                catch (InstanceNotFoundException | MBeanRegistrationException e) {
                    LOG.warn("unregister mbean {} resulted in exception", (Object)mbeanName, (Object)e);
                }
            }
            this.server.registerMBean(this, mbeanName);
            registered = true;
            LOG.debug("MBean {} registered successfully", (Object)mbeanName.getCanonicalName());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOG.error("registration failed {}", (Throwable)e);
        }
        return registered;
    }

    public void unregister() {
        this.unregisterMBean();
    }

    public boolean unregisterMBean() {
        boolean unregister = false;
        try {
            ObjectName mbeanName = this.getMBeanObjectName();
            this.unregisterMBean(mbeanName);
            unregister = true;
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            LOG.debug("Failed when unregistering MBean {}", (Throwable)e);
        }
        return unregister;
    }

    private void unregisterMBean(ObjectName mbeanName) throws MBeanRegistrationException, InstanceNotFoundException {
        this.server.unregisterMBean(mbeanName);
    }

    public String getMBeanName() {
        return this.beanName;
    }

    public String getMBeanType() {
        return this.beanType;
    }

    public String getMBeanCategory() {
        return this.beanCategory;
    }
}

