/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.util.jmx;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.QueuedNotificationManagerMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.QueuedNotificationManagerStats;
import org.opendaylight.yangtools.util.concurrent.ListenerNotificationQueueStats;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;

public class QueuedNotificationManagerMXBeanImpl
extends AbstractMXBean
implements QueuedNotificationManagerMXBean {
    private final QueuedNotificationManager<?, ?> manager;

    public QueuedNotificationManagerMXBeanImpl(QueuedNotificationManager<?, ?> manager, String beanName, String beanType, String beanCategory) {
        super(beanName, beanType, beanCategory);
        this.manager = (QueuedNotificationManager)Preconditions.checkNotNull(manager);
    }

    @Override
    public List<ListenerNotificationQueueStats> getCurrentListenerQueueStats() {
        return this.manager.getListenerNotificationQueueStats();
    }

    @Override
    public int getMaxListenerQueueSize() {
        return this.manager.getMaxQueueCapacity();
    }

    public QueuedNotificationManagerStats toQueuedNotificationManagerStats() {
        return new QueuedNotificationManagerStats(this.getMaxListenerQueueSize(), this.getCurrentListenerQueueStats());
    }
}

