/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.util.jmx;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.ThreadExecutorStats;
import org.opendaylight.controller.md.sal.common.util.jmx.ThreadExecutorStatsMXBean;
import org.opendaylight.yangtools.util.concurrent.CountingRejectedExecutionHandler;
import org.opendaylight.yangtools.util.concurrent.TrackingLinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadExecutorStatsMXBeanImpl
extends AbstractMXBean
implements ThreadExecutorStatsMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadExecutorStatsMXBeanImpl.class);
    private final ThreadPoolExecutor executor;

    public ThreadExecutorStatsMXBeanImpl(ThreadPoolExecutor executor, String beanName, String beanType, @Nullable String beanCategory) {
        super(beanName, beanType, beanCategory);
        this.executor = Objects.requireNonNull(executor);
    }

    private static ThreadExecutorStatsMXBeanImpl createInternal(Executor executor, String beanName, String beanType, String beanCategory) {
        if (executor instanceof ThreadPoolExecutor) {
            ThreadExecutorStatsMXBeanImpl ret = new ThreadExecutorStatsMXBeanImpl((ThreadPoolExecutor)executor, beanName, beanType, beanCategory);
            return ret;
        }
        LOG.info("Executor {} is not supported", (Object)executor);
        return null;
    }

    public static ThreadExecutorStatsMXBeanImpl create(Executor executor, String beanName, String beanType, @Nullable String beanCategory) {
        ThreadExecutorStatsMXBeanImpl ret = ThreadExecutorStatsMXBeanImpl.createInternal(executor, beanName, beanType, beanCategory);
        if (ret != null) {
            ret.registerMBean();
        }
        return ret;
    }

    public static ThreadExecutorStatsMXBeanImpl create(Executor executor, String beanName, String beanType) {
        return ThreadExecutorStatsMXBeanImpl.create(executor, beanName, beanType, null);
    }

    public static ThreadExecutorStatsMXBeanImpl create(Executor executor) {
        return ThreadExecutorStatsMXBeanImpl.createInternal(executor, "", "", null);
    }

    @Override
    public long getCurrentThreadPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public long getLargestThreadPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public long getMaxThreadPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public long getCurrentQueueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public Long getLargestQueueSize() {
        BlockingQueue<Runnable> queue = this.executor.getQueue();
        if (queue instanceof TrackingLinkedBlockingQueue) {
            return ((TrackingLinkedBlockingQueue)queue).getLargestQueueSize();
        }
        return null;
    }

    @Override
    public long getMaxQueueSize() {
        long queueSize = this.executor.getQueue().size();
        return (long)this.executor.getQueue().remainingCapacity() + queueSize;
    }

    @Override
    public long getActiveThreadCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public long getTotalTaskCount() {
        return this.executor.getTaskCount();
    }

    @Override
    public Long getRejectedTaskCount() {
        RejectedExecutionHandler rejectedHandler = this.executor.getRejectedExecutionHandler();
        if (rejectedHandler instanceof CountingRejectedExecutionHandler) {
            return ((CountingRejectedExecutionHandler)rejectedHandler).getRejectedTaskCount();
        }
        return null;
    }

    public ThreadExecutorStats toThreadExecutorStats() {
        return new ThreadExecutorStats(this.getActiveThreadCount(), this.getCurrentThreadPoolSize(), this.getLargestThreadPoolSize(), this.getMaxThreadPoolSize(), this.getCurrentQueueSize(), this.getLargestQueueSize(), this.getMaxQueueSize(), this.getCompletedTaskCount(), this.getTotalTaskCount(), this.getRejectedTaskCount());
    }
}

