/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.api;

import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Consumer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractConsumer
implements Consumer,
BundleActivator,
ServiceTrackerCustomizer<Broker, Broker> {
    private BundleContext context;
    private ServiceTracker<Broker, Broker> tracker;
    private Broker broker;

    public final void start(BundleContext context) throws Exception {
        this.context = context;
        this.startImpl(context);
        this.tracker = new ServiceTracker(context, Broker.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public final void stop(BundleContext context) throws Exception {
        this.stopImpl(context);
        this.broker = null;
        this.tracker.close();
    }

    protected void startImpl(BundleContext context) {
    }

    protected void stopImpl(BundleContext context) {
    }

    @Override
    public Collection<Consumer.ConsumerFunctionality> getConsumerFunctionality() {
        return Collections.emptySet();
    }

    public Broker addingService(ServiceReference<Broker> reference) {
        if (this.broker == null) {
            this.broker = (Broker)this.context.getService(reference);
            this.broker.registerConsumer(this, this.context);
            return this.broker;
        }
        return null;
    }

    public void modifiedService(ServiceReference<Broker> reference, Broker service) {
    }

    public void removedService(ServiceReference<Broker> reference, Broker service) {
        this.stopImpl(this.context);
    }
}

