/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.api;

import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractProvider
implements BundleActivator,
Provider,
ServiceTrackerCustomizer<Broker, Broker> {
    private Broker broker;
    private BundleContext context;
    private ServiceTracker<Broker, Broker> tracker;

    @Override
    public Collection<Provider.ProviderFunctionality> getProviderFunctionality() {
        return Collections.emptySet();
    }

    public final void start(BundleContext context) throws Exception {
        this.context = context;
        this.startImpl(context);
        this.tracker = new ServiceTracker(context, Broker.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    protected void startImpl(BundleContext context) {
    }

    protected void stopImpl(BundleContext context) {
    }

    public final void stop(BundleContext context) throws Exception {
        this.broker = null;
        this.tracker.close();
        this.tracker = null;
        this.stopImpl(context);
    }

    public Broker addingService(ServiceReference<Broker> reference) {
        if (this.broker == null) {
            this.broker = (Broker)this.context.getService(reference);
            this.broker.registerProvider(this, this.context);
            return this.broker;
        }
        return null;
    }

    public void modifiedService(ServiceReference<Broker> reference, Broker service) {
    }

    public void removedService(ServiceReference<Broker> reference, Broker service) {
        this.stopImpl(this.context);
    }
}

