/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.notification.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.common.rev131028.notification.state.Notifications;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NotificationsBuilder {
    private Long _published;
    private static List<Range<BigInteger>> _published_range;
    Map<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>> augmentation = new HashMap<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>>();

    public NotificationsBuilder() {
    }

    public NotificationsBuilder(Notifications base) {
        this._published = base.getPublished();
        if (base instanceof NotificationsImpl) {
            NotificationsImpl _impl = (NotificationsImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>>(_impl.augmentation);
        }
    }

    public Long getPublished() {
        return this._published;
    }

    public <E extends Augmentation<Notifications>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NotificationsBuilder setPublished(Long value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : NotificationsBuilder._published_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _published_range));
            }
        }
        this._published = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _published_range() {
        if (_published_range != null) return _published_range;
        Class<NotificationsBuilder> clazz = NotificationsBuilder.class;
        synchronized (NotificationsBuilder.class) {
            if (_published_range != null) return _published_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _published_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _published_range;
        }
    }

    public NotificationsBuilder addAugmentation(Class<? extends Augmentation<Notifications>> augmentationType, Augmentation<Notifications> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Notifications build() {
        return new NotificationsImpl(this);
    }

    private static final class NotificationsImpl
    implements Notifications {
        private final Long _published;
        private Map<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>> augmentation = new HashMap<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>>();

        public Class<Notifications> getImplementedInterface() {
            return Notifications.class;
        }

        private NotificationsImpl(NotificationsBuilder base) {
            this._published = base.getPublished();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPublished() {
            return this._published;
        }

        public <E extends Augmentation<Notifications>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._published == null ? 0 : this._published.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Notifications.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Notifications other = (Notifications)obj;
            if (this._published == null ? other.getPublished() != null : !this._published.equals(other.getPublished())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NotificationsImpl otherImpl = (NotificationsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Notifications>>, Augmentation<Notifications>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Notifications [");
            boolean first = true;
            if (this._published != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_published=");
                builder.append(this._published);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

