/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.Status;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import org.opendaylight.controller.cluster.access.client.BackendInfoResolver;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.BouncingReconnectForwarder;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.GetClientRequest;
import org.opendaylight.controller.cluster.databroker.actors.dds.HistoryReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.SingleClientHistory;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDataStoreClientBehavior
extends ClientActorBehavior<ShardBackendInfo>
implements DataStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataStoreClientBehavior.class);
    private final Map<LocalHistoryIdentifier, ClientLocalHistory> histories = new ConcurrentHashMap<LocalHistoryIdentifier, ClientLocalHistory>();
    private final AtomicLong nextHistoryId = new AtomicLong(1L);
    private final StampedLock lock = new StampedLock();
    private final SingleClientHistory singleHistory = new SingleClientHistory(this, new LocalHistoryIdentifier(this.getIdentifier(), 0L));
    private volatile Throwable aborted;

    AbstractDataStoreClientBehavior(ClientActorContext context, BackendInfoResolver<ShardBackendInfo> resolver) {
        super(context, resolver);
    }

    protected final void haltClient(Throwable cause) {
        if (this.aborted != null) {
            this.abortOperations(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortOperations(Throwable cause) {
        long stamp = this.lock.writeLock();
        try {
            this.aborted = cause;
            for (ClientLocalHistory h : this.histories.values()) {
                h.localAbort(cause);
            }
            this.histories.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private AbstractDataStoreClientBehavior shutdown(ClientActorBehavior<ShardBackendInfo> currentBehavior) {
        this.abortOperations(new IllegalStateException("Client " + this.getIdentifier() + " has been shut down"));
        return null;
    }

    protected final AbstractDataStoreClientBehavior onCommand(Object command) {
        if (command instanceof GetClientRequest) {
            ((GetClientRequest)command).getReplyTo().tell((Object)new Status.Success((Object)this), ActorRef.noSender());
        } else {
            LOG.warn("{}: ignoring unhandled command {}", (Object)this.persistenceId(), command);
        }
        return this;
    }

    protected final ClientActorBehavior.ConnectionConnectCohort connectionUp(ConnectedClientConnection<ShardBackendInfo> newConn) {
        long stamp = this.lock.writeLock();
        ArrayList<HistoryReconnectCohort> cohorts = new ArrayList<HistoryReconnectCohort>();
        AbstractDataStoreClientBehavior.startReconnect(this.singleHistory, newConn, cohorts);
        for (ClientLocalHistory h : this.histories.values()) {
            AbstractDataStoreClientBehavior.startReconnect(h, newConn, cohorts);
        }
        return previousEntries -> this.finishReconnect(newConn, stamp, cohorts, previousEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReconnectForwarder finishReconnect(ConnectedClientConnection<ShardBackendInfo> newConn, long stamp, Collection<HistoryReconnectCohort> cohorts, Collection<ConnectionEntry> previousEntries) {
        try {
            for (HistoryReconnectCohort c : cohorts) {
                c.replayRequests(previousEntries);
            }
            ReconnectForwarder reconnectForwarder = BouncingReconnectForwarder.forCohorts(newConn, cohorts);
            return reconnectForwarder;
        }
        finally {
            try {
                for (HistoryReconnectCohort c : cohorts) {
                    c.close();
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    private static void startReconnect(AbstractClientHistory history, ConnectedClientConnection<ShardBackendInfo> newConn, Collection<HistoryReconnectCohort> cohorts) {
        HistoryReconnectCohort cohort = history.startReconnect(newConn);
        if (cohort != null) {
            cohorts.add(cohort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClientLocalHistory createLocalHistory() {
        LocalHistoryIdentifier historyId = new LocalHistoryIdentifier(this.getIdentifier(), this.nextHistoryId.getAndIncrement());
        long stamp = this.lock.readLock();
        try {
            if (this.aborted != null) {
                Throwables.throwIfUnchecked((Throwable)this.aborted);
                throw new RuntimeException(this.aborted);
            }
            ClientLocalHistory history = new ClientLocalHistory(this, historyId);
            LOG.debug("{}: creating a new local history {}", (Object)this.persistenceId(), (Object)history);
            Verify.verify((this.histories.put(historyId, history) == null ? 1 : 0) != 0);
            ClientLocalHistory clientLocalHistory = history;
            return clientLocalHistory;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @Override
    public final ClientTransaction createTransaction() {
        return this.singleHistory.createTransaction();
    }

    @Override
    public final ClientSnapshot createSnapshot() {
        return this.singleHistory.takeSnapshot();
    }

    @Override
    public void close() {
        super.close();
        ((ClientActorContext)this.context()).executeInActor(this::shutdown);
    }

    abstract Long resolveShardForPath(YangInstanceIdentifier var1);
}

