/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransactionContext
implements TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionContext.class);
    private final TransactionIdentifier transactionIdentifier;
    private long modificationCount = 0L;
    private boolean handOffComplete;
    private final short transactionVersion;

    protected AbstractTransactionContext(TransactionIdentifier transactionIdentifier) {
        this(transactionIdentifier, 10);
    }

    protected AbstractTransactionContext(TransactionIdentifier transactionIdentifier, short transactionVersion) {
        this.transactionIdentifier = transactionIdentifier;
        this.transactionVersion = transactionVersion;
    }

    protected final @NonNull TransactionIdentifier getIdentifier() {
        return this.transactionIdentifier;
    }

    protected final void incrementModificationCount() {
        ++this.modificationCount;
    }

    protected final void logModificationCount() {
        LOG.debug("Total modifications on Tx {} = [ {} ]", (Object)this.getIdentifier(), (Object)this.modificationCount);
    }

    @Override
    public final void operationHandOffComplete() {
        this.handOffComplete = true;
    }

    protected boolean isOperationHandOffComplete() {
        return this.handOffComplete;
    }

    @Override
    public boolean usesOperationLimiting() {
        return false;
    }

    @Override
    public short getTransactionVersion() {
        return this.transactionVersion;
    }
}

