/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.cluster.datastore.DelayedDataTreeChangeListenerRegistration;
import org.opendaylight.controller.cluster.datastore.ForwardingDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.LeaderLocalDelegateFactory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.actors.DataTreeNotificationListenerRegistrationActor;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataTreeChangeListenerSupport
extends LeaderLocalDelegateFactory<RegisterDataTreeChangeListener> {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeChangeListenerSupport.class);
    private final Collection<DelayedDataTreeChangeListenerRegistration<DOMDataTreeChangeListener>> delayedDataTreeChangeListenerRegistrations = ConcurrentHashMap.newKeySet();
    private final Collection<DelayedDataTreeChangeListenerRegistration<DOMDataTreeChangeListener>> delayedListenerOnAllRegistrations = ConcurrentHashMap.newKeySet();
    private final Collection<ActorSelection> leaderOnlyListenerActors = ConcurrentHashMap.newKeySet();
    private final Collection<ActorSelection> allListenerActors = ConcurrentHashMap.newKeySet();

    DataTreeChangeListenerSupport(Shard shard) {
        super(shard);
    }

    void doRegistration(RegisterDataTreeChangeListener message, ActorRef registrationActor) {
        ActorSelection listenerActor = this.processListenerRegistrationMessage(message);
        ForwardingDataTreeChangeListener listener = new ForwardingDataTreeChangeListener(listenerActor);
        LOG.debug("{}: Registering listenerActor {} for path {}", new Object[]{this.persistenceId(), listenerActor, message.getPath()});
        ShardDataTree shardDataTree = this.getShard().getDataStore();
        shardDataTree.registerTreeChangeListener(message.getPath(), listener, shardDataTree.readCurrentData(), registration -> registrationActor.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration((ListenerRegistration<?>)registration, () -> this.removeListenerActor(listenerActor)), ActorRef.noSender()));
    }

    Collection<ActorSelection> getListenerActors() {
        return new ArrayList<ActorSelection>(this.allListenerActors);
    }

    @Override
    void onLeadershipChange(boolean isLeader, boolean hasLeader) {
        LOG.debug("{}: onLeadershipChange, isLeader: {}, hasLeader : {}", new Object[]{this.persistenceId(), isLeader, hasLeader});
        EnableNotification msg = new EnableNotification(isLeader, this.persistenceId());
        for (ActorSelection actorSelection : this.leaderOnlyListenerActors) {
            actorSelection.tell((Object)msg, this.getSelf());
        }
        if (hasLeader) {
            for (DelayedDataTreeChangeListenerRegistration delayedDataTreeChangeListenerRegistration : this.delayedListenerOnAllRegistrations) {
                delayedDataTreeChangeListenerRegistration.doRegistration(this);
            }
            this.delayedListenerOnAllRegistrations.clear();
        }
        if (isLeader) {
            for (DelayedDataTreeChangeListenerRegistration delayedDataTreeChangeListenerRegistration : this.delayedDataTreeChangeListenerRegistrations) {
                delayedDataTreeChangeListenerRegistration.doRegistration(this);
            }
            this.delayedDataTreeChangeListenerRegistrations.clear();
        }
    }

    @Override
    void onMessage(RegisterDataTreeChangeListener message, boolean isLeader, boolean hasLeader) {
        LOG.debug("{}: onMessage {}, isLeader: {}, hasLeader: {}", new Object[]{this.persistenceId(), message, isLeader, hasLeader});
        ActorRef registrationActor = this.createActor(DataTreeNotificationListenerRegistrationActor.props());
        if (hasLeader && message.isRegisterOnAllInstances() || isLeader) {
            this.doRegistration(message, registrationActor);
        } else {
            LOG.debug("{}: Shard does not have a leader - delaying registration", (Object)this.persistenceId());
            DelayedDataTreeChangeListenerRegistration delayedReg = new DelayedDataTreeChangeListenerRegistration(message, registrationActor);
            Collection<DelayedDataTreeChangeListenerRegistration<DOMDataTreeChangeListener>> delayedRegList = message.isRegisterOnAllInstances() ? this.delayedListenerOnAllRegistrations : this.delayedDataTreeChangeListenerRegistrations;
            delayedRegList.add(delayedReg);
            registrationActor.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(delayedReg, () -> delayedRegList.remove(delayedReg)), ActorRef.noSender());
        }
        LOG.debug("{}: sending RegisterDataTreeNotificationListenerReply, listenerRegistrationPath = {} ", (Object)this.persistenceId(), (Object)registrationActor.path());
        this.tellSender(new RegisterDataTreeNotificationListenerReply(registrationActor));
    }

    private ActorSelection processListenerRegistrationMessage(RegisterDataTreeChangeListener message) {
        ActorSelection listenerActor = this.selectActor(message.getListenerActorPath());
        listenerActor.tell((Object)new EnableNotification(true, this.persistenceId()), this.getSelf());
        if (!message.isRegisterOnAllInstances()) {
            this.leaderOnlyListenerActors.add(listenerActor);
        }
        this.allListenerActors.add(listenerActor);
        return listenerActor;
    }

    private void removeListenerActor(ActorSelection listenerActor) {
        this.allListenerActors.remove(listenerActor);
        this.leaderOnlyListenerActors.remove(listenerActor);
    }
}

