/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.OnInitialData;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForwardingDataTreeChangeListener
implements DOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingDataTreeChangeListener.class);
    private final ActorSelection actor;

    ForwardingDataTreeChangeListener(ActorSelection actor) {
        this.actor = Objects.requireNonNull(actor, "actor should not be null");
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        LOG.debug("Sending DataTreeChanged to {}", (Object)this.actor);
        this.actor.tell((Object)new DataTreeChanged(changes), ActorRef.noSender());
    }

    public void onInitialData() {
        LOG.debug("Sending OnInitialData to {}", (Object)this.actor);
        this.actor.tell((Object)OnInitialData.INSTANCE, ActorRef.noSender());
    }

    public String toString() {
        return "ForwardingDataTreeChangeListener [actor=" + this.actor + "]";
    }
}

