/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceSuccess;
import org.opendaylight.controller.cluster.access.commands.OutOfOrderRequestException;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FrontendTransaction
implements Identifiable<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendTransaction.class);
    private final AbstractFrontendHistory history;
    private final TransactionIdentifier id;
    private final Queue<Object> replayQueue = new ArrayDeque<Object>();
    private long firstReplaySequence;
    private Long lastPurgedSequence;
    private long expectedSequence;
    private RequestException previousFailure;

    FrontendTransaction(AbstractFrontendHistory history, TransactionIdentifier id) {
        this.history = Objects.requireNonNull(history);
        this.id = Objects.requireNonNull(id);
    }

    public final TransactionIdentifier getIdentifier() {
        return this.id;
    }

    final AbstractFrontendHistory history() {
        return this.history;
    }

    final String persistenceId() {
        return this.history().persistenceId();
    }

    final Optional<TransactionSuccess<?>> replaySequence(long sequence) throws RequestException {
        if (this.expectedSequence == sequence) {
            return Optional.empty();
        }
        if (Long.compareUnsigned(this.expectedSequence, sequence) < 0) {
            throw new OutOfOrderRequestException(this.expectedSequence);
        }
        if (this.lastPurgedSequence != null && Long.compareUnsigned(this.lastPurgedSequence, sequence) >= 0) {
            throw new IllegalArgumentException(String.format("Invalid purged sequence %s (last purged is %s)", sequence, this.lastPurgedSequence));
        }
        long replaySequence = this.firstReplaySequence;
        for (Object e : this.replayQueue) {
            if (replaySequence == sequence) {
                if (e instanceof RequestException) {
                    throw (RequestException)((Object)e);
                }
                Verify.verify((boolean)(e instanceof TransactionSuccess));
                return Optional.of((TransactionSuccess)e);
            }
            ++replaySequence;
        }
        return Optional.empty();
    }

    final void purgeSequencesUpTo(long sequence) {
        this.lastPurgedSequence = sequence;
    }

    final @Nullable TransactionSuccess<?> handleRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        if (request instanceof IncrementTransactionSequenceRequest) {
            IncrementTransactionSequenceRequest incr = (IncrementTransactionSequenceRequest)request;
            this.expectedSequence += incr.getIncrement();
            return this.recordSuccess(incr.getSequence(), new IncrementTransactionSequenceSuccess((TransactionIdentifier)incr.getTarget(), incr.getSequence()));
        }
        if (this.previousFailure != null) {
            LOG.debug("{}: Rejecting request {} due to previous failure", new Object[]{this.persistenceId(), request, this.previousFailure});
            throw this.previousFailure;
        }
        try {
            return this.doHandleRequest(request, envelope, now);
        }
        catch (RuntimeException e) {
            LOG.debug("{}: Request {} failed to process", new Object[]{this.persistenceId(), request, e});
            this.previousFailure = new RuntimeRequestException("Request " + request + " failed to process", (Throwable)e);
            throw this.previousFailure;
        }
    }

    abstract @Nullable TransactionSuccess<?> doHandleRequest(TransactionRequest<?> var1, RequestEnvelope var2, long var3) throws RequestException;

    abstract void retire();

    private void recordResponse(long sequence, Object response) {
        if (this.replayQueue.isEmpty()) {
            this.firstReplaySequence = sequence;
        }
        this.replayQueue.add(response);
        ++this.expectedSequence;
    }

    final <T extends TransactionSuccess<?>> T recordSuccess(long sequence, T success) {
        this.recordResponse(sequence, success);
        return success;
    }

    private long executionTime(long startTime) {
        return this.history.readTime() - startTime;
    }

    final void recordAndSendSuccess(RequestEnvelope envelope, long startTime, TransactionSuccess<?> success) {
        this.recordResponse(success.getSequence(), success);
        envelope.sendSuccess(success, this.executionTime(startTime));
    }

    final void recordAndSendFailure(RequestEnvelope envelope, long startTime, RuntimeRequestException failure) {
        this.recordResponse(((Request)envelope.getMessage()).getSequence(), failure);
        envelope.sendFailure((RequestException)failure, this.executionTime(startTime));
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", (Object)this.getIdentifier()).add("expectedSequence", this.expectedSequence).add("firstReplaySequence", this.firstReplaySequence).add("lastPurgedSequence", (Object)this.lastPurgedSequence).toString();
    }
}

