/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.OnComplete;
import akka.pattern.AskTimeoutException;
import akka.util.Timeout;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.NoOpTransactionContext;
import org.opendaylight.controller.cluster.datastore.RemoteTransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionContextCleanup;
import org.opendaylight.controller.cluster.datastore.TransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.ShardLeaderNotRespondingException;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

final class RemoteTransactionContextSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTransactionContextSupport.class);
    private static final long CREATE_TX_TRY_INTERVAL_IN_MS = 1000L;
    private static final long MAX_CREATE_TX_MSG_TIMEOUT_IN_MS = 5000L;
    private final TransactionProxy parent;
    private final String shardName;
    private volatile PrimaryShardInfo primaryShardInfo;
    private volatile long totalCreateTxTimeout;
    private final Timeout createTxMessageTimeout;
    private final TransactionContextWrapper transactionContextWrapper;

    RemoteTransactionContextSupport(TransactionContextWrapper transactionContextWrapper, TransactionProxy parent, String shardName) {
        this.parent = Objects.requireNonNull(parent);
        this.shardName = shardName;
        this.transactionContextWrapper = transactionContextWrapper;
        this.totalCreateTxTimeout = parent.getActorUtils().getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().toMillis() * 2L;
        long operationTimeout = parent.getActorUtils().getOperationTimeout().duration().toMillis();
        this.createTxMessageTimeout = new Timeout(Math.min(operationTimeout, 5000L), TimeUnit.MILLISECONDS);
    }

    String getShardName() {
        return this.shardName;
    }

    private TransactionType getTransactionType() {
        return this.parent.getType();
    }

    private ActorUtils getActorUtils() {
        return this.parent.getActorUtils();
    }

    private TransactionIdentifier getIdentifier() {
        return (TransactionIdentifier)this.parent.getIdentifier();
    }

    void setPrimaryShard(PrimaryShardInfo newPrimaryShardInfo) {
        this.primaryShardInfo = newPrimaryShardInfo;
        if (this.getTransactionType() == TransactionType.WRITE_ONLY && this.getActorUtils().getDatastoreContext().isWriteOnlyTransactionOptimizationsEnabled()) {
            ActorSelection primaryShard = newPrimaryShardInfo.getPrimaryShardActor();
            LOG.debug("Tx {} Primary shard {} found - creating WRITE_ONLY transaction context", (Object)this.getIdentifier(), (Object)primaryShard);
            this.transactionContextWrapper.executePriorTransactionOperations(this.createValidTransactionContext(primaryShard, String.valueOf(primaryShard.path()), newPrimaryShardInfo.getPrimaryShardVersion()));
        } else {
            this.tryCreateTransaction();
        }
    }

    private void tryCreateTransaction() {
        LOG.debug("Tx {} Primary shard {} found - trying create transaction", (Object)this.getIdentifier(), (Object)this.primaryShardInfo.getPrimaryShardActor());
        Object serializedCreateMessage = new CreateTransaction(this.getIdentifier(), this.getTransactionType().ordinal(), this.primaryShardInfo.getPrimaryShardVersion()).toSerializable();
        Future<Object> createTxFuture = this.getActorUtils().executeOperationAsync(this.primaryShardInfo.getPrimaryShardActor(), serializedCreateMessage, this.createTxMessageTimeout);
        createTxFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                RemoteTransactionContextSupport.this.onCreateTransactionComplete(failure, response);
            }
        }, this.getActorUtils().getClientDispatcher());
    }

    private void tryFindPrimaryShard() {
        LOG.debug("Tx {} Retrying findPrimaryShardAsync for shard {}", (Object)this.getIdentifier(), (Object)this.shardName);
        this.primaryShardInfo = null;
        Future<PrimaryShardInfo> findPrimaryFuture = this.getActorUtils().findPrimaryShardAsync(this.shardName);
        findPrimaryFuture.onComplete((Function1)new OnComplete<PrimaryShardInfo>(){

            public void onComplete(Throwable failure, PrimaryShardInfo newPrimaryShardInfo) {
                RemoteTransactionContextSupport.this.onFindPrimaryShardComplete(failure, newPrimaryShardInfo);
            }
        }, this.getActorUtils().getClientDispatcher());
    }

    private void onFindPrimaryShardComplete(Throwable failure, PrimaryShardInfo newPrimaryShardInfo) {
        if (failure == null) {
            this.primaryShardInfo = newPrimaryShardInfo;
            this.tryCreateTransaction();
        } else {
            LOG.debug("Tx {}: Find primary for shard {} failed", new Object[]{this.getIdentifier(), this.shardName, failure});
            this.onCreateTransactionComplete(failure, null);
        }
    }

    private void onCreateTransactionComplete(Throwable failure, Object response) {
        boolean retryCreateTransaction;
        boolean bl = retryCreateTransaction = this.primaryShardInfo != null && (failure instanceof NoShardLeaderException || failure instanceof AskTimeoutException);
        if (retryCreateTransaction && this.totalCreateTxTimeout > 0L) {
            long scheduleInterval = 1000L;
            if (failure instanceof AskTimeoutException) {
                this.totalCreateTxTimeout -= this.createTxMessageTimeout.duration().toMillis();
                scheduleInterval = 10L;
            }
            this.totalCreateTxTimeout -= scheduleInterval;
            LOG.debug("Tx {}: create tx on shard {} failed with exception \"{}\" - scheduling retry in {} ms", new Object[]{this.getIdentifier(), this.shardName, failure, scheduleInterval});
            this.getActorUtils().getActorSystem().scheduler().scheduleOnce(FiniteDuration.create((long)scheduleInterval, (TimeUnit)TimeUnit.MILLISECONDS), this::tryFindPrimaryShard, this.getActorUtils().getClientDispatcher());
            return;
        }
        this.createTransactionContext(failure, response);
    }

    private void createTransactionContext(Throwable failure, Object response) {
        TransactionContext localTransactionContext;
        if (failure != null) {
            LOG.debug("Tx {} Creating NoOpTransaction because of error", (Object)this.getIdentifier(), (Object)failure);
            Throwable resultingEx = failure;
            if (failure instanceof AskTimeoutException) {
                resultingEx = new ShardLeaderNotRespondingException(String.format("Could not create a %s transaction on shard %s. The shard leader isn't responding.", new Object[]{this.parent.getType(), this.shardName}), failure);
            } else if (!(failure instanceof NoShardLeaderException)) {
                resultingEx = new Exception(String.format("Error creating %s transaction on shard %s", new Object[]{this.parent.getType(), this.shardName}), failure);
            }
            localTransactionContext = new NoOpTransactionContext(resultingEx, this.getIdentifier());
        } else if (CreateTransactionReply.isSerializedType(response)) {
            localTransactionContext = this.createValidTransactionContext(CreateTransactionReply.fromSerializable(response));
        } else {
            IllegalArgumentException exception = new IllegalArgumentException(String.format("Invalid reply type %s for CreateTransaction", response.getClass()));
            localTransactionContext = new NoOpTransactionContext(exception, this.getIdentifier());
        }
        this.transactionContextWrapper.executePriorTransactionOperations(localTransactionContext);
    }

    private TransactionContext createValidTransactionContext(CreateTransactionReply reply) {
        LOG.debug("Tx {} Received {}", (Object)this.getIdentifier(), (Object)reply);
        return this.createValidTransactionContext(this.getActorUtils().actorSelection(reply.getTransactionPath()), reply.getTransactionPath(), this.primaryShardInfo.getPrimaryShardVersion());
    }

    private TransactionContext createValidTransactionContext(ActorSelection transactionActor, String transactionPath, short remoteTransactionVersion) {
        RemoteTransactionContext ret = new RemoteTransactionContext(this.transactionContextWrapper.getIdentifier(), transactionActor, this.getActorUtils(), remoteTransactionVersion, this.transactionContextWrapper.getLimiter());
        if (this.parent.getType() == TransactionType.READ_ONLY) {
            TransactionContextCleanup.track(this.parent, ret);
        }
        return ret;
    }
}

