/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.entityownership.AbstractEntityOwnerChangeListener;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipChangePublisher;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityOwnerChangeListener
extends AbstractEntityOwnerChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnerChangeListener.class);
    private final String localMemberName;
    private final EntityOwnershipChangePublisher publisher;

    EntityOwnerChangeListener(MemberName localMemberName, EntityOwnershipChangePublisher publisher) {
        this.localMemberName = (String)Verify.verifyNotNull((Object)localMemberName.getName());
        this.publisher = Objects.requireNonNull(publisher);
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        for (DataTreeCandidate change : changes) {
            DataTreeCandidateNode changeRoot = change.getRootNode();
            LeafNode ownerLeaf = (LeafNode)changeRoot.getDataAfter().get();
            LOG.debug("{}: Entity node changed: {}, {}", new Object[]{this.logId(), changeRoot.getModificationType(), change.getRootPath()});
            String newOwner = EntityOwnerChangeListener.extractOwner(ownerLeaf);
            String origOwner = null;
            Optional dataBefore = changeRoot.getDataBefore();
            if (dataBefore.isPresent()) {
                origOwner = EntityOwnerChangeListener.extractOwner((LeafNode)changeRoot.getDataBefore().get());
            }
            LOG.debug("{}: New owner: {}, Original owner: {}", new Object[]{this.logId(), newOwner, origOwner});
            if (Objects.equals(origOwner, newOwner)) continue;
            boolean isOwner = this.localMemberName.equals(newOwner);
            boolean wasOwner = this.localMemberName.equals(origOwner);
            boolean hasOwner = !Strings.isNullOrEmpty((String)newOwner);
            DOMEntity entity = EntityOwnersModel.createEntity(change.getRootPath());
            LOG.debug("{}: Calling notifyEntityOwnershipListeners: entity: {}, wasOwner: {}, isOwner: {}, hasOwner: {}", new Object[]{this.logId(), entity, wasOwner, isOwner, hasOwner});
            this.publisher.notifyEntityOwnershipListeners(entity, wasOwner, isOwner, hasOwner);
        }
    }

    private String logId() {
        return this.publisher.getLogId();
    }
}

