/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipChangePublisher;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipListenerActor;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipChangeState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityOwnershipListenerSupport
extends EntityOwnershipChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnershipListenerSupport.class);
    private final String logId;
    private final ActorContext actorContext;
    private final ReadWriteLock listenerLock = new ReentrantReadWriteLock();
    private final @GuardedBy(value={"listenerLock"}) Map<DOMEntityOwnershipListener, ListenerActorRefEntry> listenerActorMap = new IdentityHashMap<DOMEntityOwnershipListener, ListenerActorRefEntry>();
    private final @GuardedBy(value={"listenerLock"}) Multimap<String, DOMEntityOwnershipListener> entityTypeListenerMap = HashMultimap.create();
    private volatile boolean inJeopardy = false;

    EntityOwnershipListenerSupport(ActorContext actorContext, String logId) {
        this.actorContext = actorContext;
        this.logId = logId;
    }

    @Override
    String getLogId() {
        return this.logId;
    }

    boolean setInJeopardy(boolean inJeopardy) {
        boolean wasInJeopardy = this.inJeopardy;
        this.inJeopardy = inJeopardy;
        return wasInJeopardy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntityOwnershipListener(String entityType, DOMEntityOwnershipListener listener) {
        LOG.debug("{}: Adding EntityOwnershipListener {} for entity type {}", new Object[]{this.logId, listener, entityType});
        this.listenerLock.writeLock().lock();
        try {
            if (this.entityTypeListenerMap.put((Object)entityType, (Object)listener)) {
                ListenerActorRefEntry listenerEntry = this.listenerActorMap.get(listener);
                if (listenerEntry == null) {
                    this.listenerActorMap.put(listener, new ListenerActorRefEntry(listener));
                } else {
                    ++listenerEntry.referenceCount;
                }
            }
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntityOwnershipListener(String entityType, DOMEntityOwnershipListener listener) {
        LOG.debug("{}: Removing EntityOwnershipListener {} for entity type {}", new Object[]{this.logId, listener, entityType});
        this.listenerLock.writeLock().lock();
        try {
            if (this.entityTypeListenerMap.remove((Object)entityType, (Object)listener)) {
                ListenerActorRefEntry listenerEntry = this.listenerActorMap.get(listener);
                LOG.debug("{}: Found {}", (Object)this.logId, (Object)listenerEntry);
                --listenerEntry.referenceCount;
                if (listenerEntry.referenceCount <= 0) {
                    this.listenerActorMap.remove(listener);
                    if (listenerEntry.actorRef != null) {
                        LOG.debug("Killing EntityOwnershipListenerActor {}", (Object)listenerEntry.actorRef);
                        listenerEntry.actorRef.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
                    }
                }
            }
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void notifyEntityOwnershipListeners(DOMEntity entity, boolean wasOwner, boolean isOwner, boolean hasOwner) {
        this.listenerLock.readLock().lock();
        try {
            Collection listeners = this.entityTypeListenerMap.get((Object)entity.getType());
            if (!listeners.isEmpty()) {
                this.notifyListeners(entity, wasOwner, isOwner, hasOwner, listeners.stream().map(this.listenerActorMap::get).collect(Collectors.toList()));
            }
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEntityOwnershipListener(DOMEntity entity, boolean wasOwner, boolean isOwner, boolean hasOwner, DOMEntityOwnershipListener listener) {
        this.listenerLock.readLock().lock();
        try {
            this.notifyListeners(entity, wasOwner, isOwner, hasOwner, (Collection<ListenerActorRefEntry>)ImmutableList.of((Object)this.listenerActorMap.get(listener)));
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
    }

    @Holding(value={"listenerLock"})
    private void notifyListeners(DOMEntity entity, boolean wasOwner, boolean isOwner, boolean hasOwner, Collection<ListenerActorRefEntry> listenerEntries) {
        DOMEntityOwnershipChange changed = new DOMEntityOwnershipChange(entity, EntityOwnershipChangeState.from((boolean)wasOwner, (boolean)isOwner, (boolean)hasOwner), this.inJeopardy);
        for (ListenerActorRefEntry entry : listenerEntries) {
            ActorRef listenerActor = entry.actorFor();
            LOG.debug("{}: Notifying EntityOwnershipListenerActor {} with {}", new Object[]{this.logId, listenerActor, changed});
            listenerActor.tell((Object)changed, ActorRef.noSender());
        }
    }

    private class ListenerActorRefEntry {
        final DOMEntityOwnershipListener listener;
        @GuardedBy(value={"listenerLock"}) ActorRef actorRef;
        @GuardedBy(value={"listenerLock"}) int referenceCount = 1;

        ListenerActorRefEntry(DOMEntityOwnershipListener listener) {
            this.listener = listener;
        }

        ActorRef actorFor() {
            if (this.actorRef == null) {
                this.actorRef = EntityOwnershipListenerSupport.this.actorContext.actorOf(EntityOwnershipListenerActor.props(this.listener));
                LOG.debug("{}: Created EntityOwnershipListenerActor {} for listener {}", new Object[]{EntityOwnershipListenerSupport.this.logId, this.actorRef, this.listener});
            }
            return this.actorRef;
        }

        public String toString() {
            return "ListenerActorRefEntry [actorRef=" + this.actorRef + ", referenceCount=" + this.referenceCount + "]";
        }
    }
}

