/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.controller.cluster.datastore.entityownership.AbstractEntityOwnerChangeListener;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnersModel;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import tech.pantheon.triemap.TrieMap;

class EntityOwnershipStatistics
extends AbstractEntityOwnerChangeListener {
    private final TrieMap<String, TrieMap<String, Long>> statistics = TrieMap.create();

    EntityOwnershipStatistics() {
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        for (DataTreeCandidate change : changes) {
            String origOwner;
            Optional dataBefore;
            DataTreeCandidateNode changeRoot = change.getRootNode();
            LeafNode ownerLeaf = (LeafNode)changeRoot.getDataAfter().get();
            String entityType = EntityOwnersModel.entityTypeFromEntityPath(change.getRootPath());
            String newOwner = EntityOwnershipStatistics.extractOwner(ownerLeaf);
            if (!Strings.isNullOrEmpty((String)newOwner)) {
                this.updateStatistics(entityType, newOwner, 1L);
            }
            if (!(dataBefore = changeRoot.getDataBefore()).isPresent() || Strings.isNullOrEmpty((String)(origOwner = EntityOwnershipStatistics.extractOwner((LeafNode)changeRoot.getDataBefore().get())))) continue;
            this.updateStatistics(entityType, origOwner, -1L);
        }
    }

    Map<String, Map<String, Long>> all() {
        HashMap<String, Map<String, Long>> snapshot = new HashMap<String, Map<String, Long>>();
        for (String entityType : this.statistics.immutableSnapshot().keySet()) {
            snapshot.put(entityType, this.byEntityType(entityType));
        }
        return snapshot;
    }

    Map<String, Long> byEntityType(String entityType) {
        if (this.statistics.get((Object)entityType) != null) {
            return ((TrieMap)this.statistics.get((Object)entityType)).immutableSnapshot();
        }
        return new HashMap<String, Long>();
    }

    private void updateStatistics(String entityType, String candidateName, long count) {
        TrieMap map = (TrieMap)this.statistics.get((Object)entityType);
        if (map == null) {
            map = TrieMap.create();
            map.put((Object)candidateName, (Object)count);
            this.statistics.put((Object)entityType, (Object)map);
        } else {
            map.merge((Object)candidateName, (Object)count, (ownedEntities, addedEntities) -> ownedEntities + addedEntities);
        }
    }
}

