/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership.messages;

import java.util.Collection;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class SelectOwner {
    private final YangInstanceIdentifier entityPath;
    private final Collection<String> allCandidates;
    private final EntityOwnerSelectionStrategy ownerSelectionStrategy;

    public SelectOwner(YangInstanceIdentifier entityPath, Collection<String> allCandidates, EntityOwnerSelectionStrategy ownerSelectionStrategy) {
        this.entityPath = Objects.requireNonNull(entityPath, "entityPath should not be null");
        this.allCandidates = Objects.requireNonNull(allCandidates, "allCandidates should not be null");
        this.ownerSelectionStrategy = Objects.requireNonNull(ownerSelectionStrategy, "ownerSelectionStrategy should not be null");
    }

    public YangInstanceIdentifier getEntityPath() {
        return this.entityPath;
    }

    public Collection<String> getAllCandidates() {
        return this.allCandidates;
    }

    public EntityOwnerSelectionStrategy getOwnerSelectionStrategy() {
        return this.ownerSelectionStrategy;
    }

    public String toString() {
        return "SelectOwner [entityPath=" + this.entityPath + ", allCandidates=" + this.allCandidates + ", ownerSelectionStrategy=" + this.ownerSelectionStrategy + "]";
    }
}

