/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityOwnerSelectionStrategyConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnerSelectionStrategyConfigReader.class);
    private static final String ENTITY_TYPE_PREFIX = "entity.type.";

    private EntityOwnerSelectionStrategyConfigReader() {
    }

    public static EntityOwnerSelectionStrategyConfig loadStrategyWithConfig(Map<Object, Object> props) {
        EntityOwnerSelectionStrategyConfig.Builder builder = EntityOwnerSelectionStrategyConfig.newBuilder();
        if (props != null && !props.isEmpty()) {
            EntityOwnerSelectionStrategyConfigReader.parseConfiguration(builder, props);
        } else if (props == null) {
            LOG.debug("Could not read strategy configuration file, will use default configuration.");
        } else {
            LOG.debug("Configuration file is empty, will use default configuration.");
        }
        return builder.build();
    }

    private static EntityOwnerSelectionStrategyConfig parseConfiguration(EntityOwnerSelectionStrategyConfig.Builder builder, Map<Object, Object> properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(ENTITY_TYPE_PREFIX)) {
                LOG.debug("Ignoring non-conforming property key : {}", (Object)key);
                continue;
            }
            String[] strategyClassAndDelay = ((String)properties.get(key)).split(",");
            Class<? extends EntityOwnerSelectionStrategy> aClass = EntityOwnerSelectionStrategyConfigReader.loadClass(strategyClassAndDelay[0]);
            long delay = strategyClassAndDelay.length > 1 ? Long.parseLong(strategyClassAndDelay[1]) : 0L;
            String entityType = key.substring(key.lastIndexOf(".") + 1);
            builder.addStrategy(entityType, aClass, delay);
            LOG.debug("Entity Type '{}' using strategy {} delay {}", new Object[]{entityType, aClass, delay});
        }
        return builder.build();
    }

    private static Class<? extends EntityOwnerSelectionStrategy> loadClass(String strategyClassAndDelay) {
        Class<?> clazz;
        try {
            clazz = EntityOwnerSelectionStrategyConfigReader.class.getClassLoader().loadClass(strategyClassAndDelay);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load strategy " + strategyClassAndDelay, e);
        }
        Preconditions.checkArgument((boolean)EntityOwnerSelectionStrategy.class.isAssignableFrom(clazz), (Object)"Selected implementation %s must implement EntityOwnerSelectionStrategy, clazz");
        return clazz;
    }
}

