/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ActorSelection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;

public class PrimaryShardInfo {
    private final ActorSelection primaryShardActor;
    private final short primaryShardVersion;
    private final ReadOnlyDataTree localShardDataTree;

    public PrimaryShardInfo(@NonNull ActorSelection primaryShardActor, short primaryShardVersion, @NonNull ReadOnlyDataTree localShardDataTree) {
        this.primaryShardActor = Objects.requireNonNull(primaryShardActor);
        this.primaryShardVersion = primaryShardVersion;
        this.localShardDataTree = Objects.requireNonNull(localShardDataTree);
    }

    public PrimaryShardInfo(@NonNull ActorSelection primaryShardActor, short primaryShardVersion) {
        this.primaryShardActor = Objects.requireNonNull(primaryShardActor);
        this.primaryShardVersion = primaryShardVersion;
        this.localShardDataTree = null;
    }

    public @NonNull ActorSelection getPrimaryShardActor() {
        return this.primaryShardActor;
    }

    public short getPrimaryShardVersion() {
        return this.primaryShardVersion;
    }

    public @NonNull Optional<ReadOnlyDataTree> getLocalShardDataTree() {
        return Optional.ofNullable(this.localShardDataTree);
    }
}

