/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public class WriteModification
extends AbstractModification {
    private static final long serialVersionUID = 1L;
    private NormalizedNode<?, ?> data;

    public WriteModification() {
        this(10);
    }

    public WriteModification(short version) {
        super(version);
    }

    WriteModification(short version, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        super(version, path);
        this.data = data;
    }

    public WriteModification(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        super(path);
        this.data = data;
    }

    @Override
    public void apply(DOMStoreWriteTransaction transaction) {
        transaction.write(this.getPath(), this.data);
    }

    @Override
    public void apply(DataTreeModification transaction) {
        transaction.write(this.getPath(), this.data);
    }

    public NormalizedNode<?, ?> getData() {
        return this.data;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        SerializationUtils.readNodeAndPath((DataInput)in, (Object)this, (instance, path, node) -> {
            instance.setPath(path);
            instance.data = node;
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationUtils.writeNodeAndPath((DataOutput)out, (YangInstanceIdentifier)this.getPath(), this.data);
    }

    public static WriteModification fromStream(NormalizedNodeDataInput in, short version, ReusableStreamReceiver receiver) throws IOException {
        NormalizedNode node = in.readNormalizedNode(receiver);
        YangInstanceIdentifier path = in.readYangInstanceIdentifier();
        return new WriteModification(version, path, node);
    }

    @Override
    public void writeTo(NormalizedNodeDataOutput out) throws IOException {
        out.writeNormalizedNode(this.data);
        out.writeYangInstanceIdentifier(this.getPath());
    }
}

