/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;

@Beta
public abstract class AbstractVersionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final @NonNull PayloadVersion closestVersion;
    private final int version;

    AbstractVersionException(String message, short version, PayloadVersion closestVersion) {
        super(message);
        this.closestVersion = Objects.requireNonNull(closestVersion);
        this.version = Short.toUnsignedInt(version);
    }

    public final int getVersion() {
        return this.version;
    }

    public final @NonNull PayloadVersion getClosestVersion() {
        return this.closestVersion;
    }
}

